/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class PathsXml {
    protected static final Set<String> RESTRICTED_PATHS;

    PathsXml() {
    }

    void parsePaths(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean requirePath) throws XMLStreamException {
        HashSet<String> pathNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            switch (element) {
                case PATH: {
                    this.parsePath(reader, address, list, requirePath, pathNames);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requirePath, Set<String> defined) throws XMLStreamException {
        String name = null;
        ModelNode path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    if (RESTRICTED_PATHS.contains(value)) {
                        throw ControllerLogger.ROOT_LOGGER.reserved(name, reader.getLocation());
                    }
                    if (defined.add(name)) continue block5;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDefined(name, reader.getLocation());
                }
                case PATH: {
                    path = ParseUtils.parsePossibleExpression((String)value);
                    continue block5;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (requirePath && path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode update = new ModelNode();
        update.get("address").set(address).add("path", name);
        update.get("operation").set("add");
        if (path != null) {
            update.get("path").set(path);
        }
        if (relativeTo != null) {
            update.get("relative-to").set(relativeTo);
        }
        list.add(update);
    }

    void writePaths(XMLExtendedStreamWriter writer, ModelNode node, boolean namedPath) throws XMLStreamException {
        List paths = node.asPropertyList();
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            ModelNode path = ((Property)it.next()).getValue();
            if (path.isDefined()) continue;
            it.remove();
        }
        if (!paths.isEmpty()) {
            writer.writeStartElement(Element.PATHS.getLocalName());
            for (ModelNode path : paths) {
                ModelNode value = path.getValue();
                writer.writeEmptyElement(Element.PATH.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), path.getName());
                if (!namedPath || value.get("path").isDefined()) {
                    writer.writeAttribute(Attribute.PATH.getLocalName(), value.get("path").asString());
                }
                if (!value.has("relative-to") || !value.get("relative-to").isDefined()) continue;
                writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), value.get("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    static {
        HashSet<String> set = new HashSet<String>(10);
        set.add("jboss.home");
        set.add("jboss.home.dir");
        set.add("user.home");
        set.add("user.dir");
        set.add("java.home");
        set.add("jboss.server.base.dir");
        set.add("jboss.server.data.dir");
        set.add("jboss.server.log.dir");
        set.add("jboss.server.temp.dir");
        set.add("jboss.modules.dir");
        set.add("jboss.server.deploy.dir");
        set.add("jboss.domain.servers.dir");
        RESTRICTED_PATHS = Collections.unmodifiableSet(set);
    }
}

