/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.AggregatePathFilter;
import org.jboss.modules.filter.BooleanPathFilter;
import org.jboss.modules.filter.ChildPathFilter;
import org.jboss.modules.filter.EqualsPathFilter;
import org.jboss.modules.filter.GlobPathFilter;
import org.jboss.modules.filter.InvertingPathFilter;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.SetPathFilter;

public final class PathFilters {
    private static final PathFilter defaultImportFilter;
    private static final PathFilter defaultImportFilterWithServices;
    private static final PathFilter metaInfFilter;
    private static final PathFilter metaInfSubdirectoriesFilter;
    private static final PathFilter metaInfServicesFilter;
    private static final PathFilter metaInfSubdirectoriesWithoutMetaInfFilter;

    private PathFilters() {
    }

    public static PathFilter all(PathFilter ... filters) {
        return new AggregatePathFilter(false, filters);
    }

    public static PathFilter all(Collection<PathFilter> filters) {
        return PathFilters.all((PathFilter[])filters.toArray(PathFilter[]::new));
    }

    public static PathFilter any(PathFilter ... filters) {
        return new AggregatePathFilter(true, filters);
    }

    public static PathFilter any(Collection<PathFilter> filters) {
        return PathFilters.any((PathFilter[])filters.toArray(PathFilter[]::new));
    }

    public static PathFilter none(PathFilter ... filters) {
        return PathFilters.not(PathFilters.any(filters));
    }

    public static PathFilter none(Collection<PathFilter> filters) {
        return PathFilters.not(PathFilters.any(filters));
    }

    public static PathFilter not(PathFilter filter) {
        if (filter instanceof BooleanPathFilter) {
            return PathFilters.booleanFilter(!((BooleanPathFilter)filter).getResult());
        }
        if (filter instanceof InvertingPathFilter) {
            return ((InvertingPathFilter)filter).getDelegate();
        }
        return new InvertingPathFilter(filter);
    }

    public static PathFilter match(String glob) {
        return new GlobPathFilter(glob);
    }

    public static PathFilter is(String path) {
        return new EqualsPathFilter(path);
    }

    public static PathFilter isChildOf(String path) {
        return new ChildPathFilter(path);
    }

    public static PathFilter isOrIsChildOf(String path) {
        return PathFilters.any(PathFilters.is(path), PathFilters.isChildOf(path));
    }

    public static MultiplePathFilterBuilder multiplePathFilterBuilder(boolean defaultValue) {
        return new MultiplePathFilterBuilder(defaultValue);
    }

    private static BooleanPathFilter booleanFilter(boolean val) {
        return val ? BooleanPathFilter.TRUE : BooleanPathFilter.FALSE;
    }

    public static PathFilter acceptAll() {
        return BooleanPathFilter.TRUE;
    }

    public static PathFilter rejectAll() {
        return BooleanPathFilter.FALSE;
    }

    public static PathFilter in(Set<String> paths) {
        return new SetPathFilter(new HashSet<String>(paths));
    }

    public static PathFilter in(Collection<String> paths) {
        return new SetPathFilter(new HashSet<String>(paths));
    }

    public static Iterator<Resource> filtered(final PathFilter filter, final Iterator<Resource> original) {
        return new Iterator<Resource>(){
            private Resource next;

            @Override
            public boolean hasNext() {
                while (this.next == null && original.hasNext()) {
                    Resource next = (Resource)original.next();
                    if (!filter.accept(next.getName())) continue;
                    this.next = next;
                }
                return this.next != null;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Resource resource = this.next;
                    return resource;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                original.remove();
            }
        };
    }

    public static PathFilter getDefaultImportFilter() {
        return defaultImportFilter;
    }

    public static PathFilter getDefaultImportFilterWithServices() {
        return defaultImportFilterWithServices;
    }

    public static PathFilter getMetaInfFilter() {
        return metaInfFilter;
    }

    public static PathFilter getMetaInfSubdirectoriesFilter() {
        return metaInfSubdirectoriesFilter;
    }

    public static PathFilter getMetaInfServicesFilter() {
        return metaInfServicesFilter;
    }

    public static PathFilter getMetaInfSubdirectoriesWithoutMetaInfFilter() {
        return metaInfSubdirectoriesWithoutMetaInfFilter;
    }

    static {
        PathFilter metaInfChildren = PathFilters.isChildOf("META-INF");
        PathFilter metaInf = PathFilters.is("META-INF");
        PathFilter metaInfServicesChildren = PathFilters.isChildOf("META-INF/services");
        PathFilter metaInfServices = PathFilters.is("META-INF/services");
        metaInfFilter = metaInf;
        metaInfSubdirectoriesFilter = metaInfChildren;
        metaInfServicesFilter = PathFilters.any(metaInfServices, metaInfServicesChildren);
        MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder(true);
        builder.addFilter(metaInfChildren, false);
        builder.addFilter(metaInf, false);
        defaultImportFilter = builder.create();
        MultiplePathFilterBuilder builder2 = PathFilters.multiplePathFilterBuilder(true);
        builder2.addFilter(metaInfServices, true);
        builder2.addFilter(metaInfServicesChildren, true);
        builder2.addFilter(metaInfChildren, false);
        builder2.addFilter(metaInf, false);
        defaultImportFilterWithServices = builder2.create();
        MultiplePathFilterBuilder builder3 = PathFilters.multiplePathFilterBuilder(true);
        builder2.addFilter(metaInfChildren, true);
        builder3.addFilter(metaInf, false);
        metaInfSubdirectoriesWithoutMetaInfFilter = builder3.create();
    }
}

