/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jgroups.auth.AuthToken;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class AuthTokenResourceDefinition<T extends AuthToken>
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator,
ResourceModelResolver<Map.Entry<Function<String, T>, Consumer<RequirementServiceBuilder<?>>>> {
    static final PathElement WILDCARD_PATH = AuthTokenResourceDefinition.pathElement("*");
    static final BinaryServiceDescriptor<AuthToken> SERVICE_DESCRIPTOR = BinaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.auth-token", AuthToken.class);
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).build();
    private static final Function<CredentialSource, String> CREDENTIAL_SOURCE_MAPPER = new Function<CredentialSource, String>(){

        @Override
        public String apply(CredentialSource sharedSecretSource) {
            try {
                PasswordCredential credential = (PasswordCredential)sharedSecretSource.getCredential(PasswordCredential.class);
                ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
                return String.valueOf(password.getPassword());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    };
    protected final UnaryOperator<ResourceDescriptor> configurator;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"token", (String)value);
    }

    AuthTokenResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator) {
        super(path, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(path, WILDCARD_PATH));
        this.configurator = configurator;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addAttribute((org.jboss.as.clustering.controller.Attribute)Attribute.SHARED_SECRET, (OperationStepHandler)new CredentialReferenceWriteAttributeHandler(Attribute.SHARED_SECRET.getDefinition())).addCapabilities(List.of(CAPABILITY));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ServiceDependency credentialSource = ServiceDependency.from((org.wildfly.service.ServiceDependency)CredentialReference.getCredentialSourceDependency((OperationContext)context, (AttributeDefinition)Attribute.SHARED_SECRET.getDefinition(), (ModelNode)model));
        Map.Entry entry = (Map.Entry)this.resolve(context, model);
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CAPABILITY, CREDENTIAL_SOURCE_MAPPER.andThen((Function)entry.getKey()), (Supplier)credentialSource).requires(List.of(credentialSource, (Consumer)entry.getValue()))).build();
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        SHARED_SECRET((AttributeDefinition)CredentialReference.getAttributeBuilder((String)"shared-secret-reference", null, (boolean)false, (CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.CREDENTIAL_STORE).build()).build());

        private final AttributeDefinition definition;

        private Attribute(AttributeDefinition definition) {
            this.definition = definition;
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

