/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyGuard;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ApplyGuardConfig;
import io.smallrye.faulttolerance.config.ConfigUtil;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ApplyGuardConfigImpl
implements ApplyGuardConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final ApplyGuard instance;
    private final boolean onMethod;
    private String _value;

    private ApplyGuardConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.applyGuard;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyGuard.class);
    }

    public static ApplyGuardConfigImpl create(FaultToleranceMethod method) {
        if (method.applyGuard == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(ApplyGuard.class, method.method)) {
            return null;
        }
        return new ApplyGuardConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return ApplyGuard.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public String value() {
        if (this._value == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(ApplyGuard.class, "value", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(ApplyGuard.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(ApplyGuard.class, "value", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(ApplyGuard.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (this._value == null) {
                newKey = ConfigUtil.newKey(ApplyGuard.class, "value");
                oldKey = ConfigUtil.oldKey(ApplyGuard.class, "value");
                this._value = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public void materialize() {
        this.value();
    }
}

