/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.FallbackConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

public final class FallbackConfigImpl
implements FallbackConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Fallback instance;
    private final boolean onMethod;
    private Class<? extends FallbackHandler<?>> _value;
    private String _fallbackMethod;
    private Class<? extends Throwable>[] _applyOn;
    private Class<? extends Throwable>[] _skipOn;

    private FallbackConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.fallback;
        this.onMethod = method.annotationsPresentDirectly.contains(Fallback.class);
    }

    public static FallbackConfigImpl create(FaultToleranceMethod method) {
        if (method.fallback == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(Fallback.class, method.method)) {
            return null;
        }
        return new FallbackConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Fallback.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<? extends FallbackHandler<?>> value() {
        if (this._value == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Fallback.class, "value", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Fallback.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Fallback.class, "value", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Fallback.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._value == null) {
                newKey = ConfigUtil.newKey(Fallback.class, "value");
                oldKey = ConfigUtil.oldKey(Fallback.class, "value");
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public String fallbackMethod() {
        if (this._fallbackMethod == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Fallback.class, "fallbackMethod", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Fallback.class, "fallbackMethod", this.method.declaringClass, this.method.name);
                this._fallbackMethod = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Fallback.class, "fallbackMethod", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Fallback.class, "fallbackMethod", this.method.declaringClass);
                this._fallbackMethod = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (this._fallbackMethod == null) {
                newKey = ConfigUtil.newKey(Fallback.class, "fallbackMethod");
                oldKey = ConfigUtil.oldKey(Fallback.class, "fallbackMethod");
                this._fallbackMethod = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (this._fallbackMethod == null) {
                this._fallbackMethod = this.instance.fallbackMethod();
            }
        }
        return this._fallbackMethod;
    }

    public Class<? extends Throwable>[] applyOn() {
        if (this._applyOn == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Fallback.class, "applyOn", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Fallback.class, "applyOn", this.method.declaringClass, this.method.name);
                this._applyOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Fallback.class, "applyOn", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Fallback.class, "applyOn", this.method.declaringClass);
                this._applyOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._applyOn == null) {
                newKey = ConfigUtil.newKey(Fallback.class, "applyOn");
                oldKey = ConfigUtil.oldKey(Fallback.class, "applyOn");
                this._applyOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._applyOn == null) {
                this._applyOn = this.instance.applyOn();
            }
        }
        return this._applyOn;
    }

    public Class<? extends Throwable>[] skipOn() {
        if (this._skipOn == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Fallback.class, "skipOn", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Fallback.class, "skipOn", this.method.declaringClass, this.method.name);
                this._skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Fallback.class, "skipOn", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Fallback.class, "skipOn", this.method.declaringClass);
                this._skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._skipOn == null) {
                newKey = ConfigUtil.newKey(Fallback.class, "skipOn");
                oldKey = ConfigUtil.oldKey(Fallback.class, "skipOn");
                this._skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = this.instance.skipOn();
            }
        }
        return this._skipOn;
    }

    public void materialize() {
        this.value();
        this.fallbackMethod();
        this.applyOn();
        this.skipOn();
    }
}

