/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateXidImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.ats.jta.xa.XidImple;
import jakarta.transaction.SystemException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ImportedTransaction;
import org.jboss.tm.TransactionImportResult;

public class TransactionImporterImple
implements TransactionImporter {
    private static ConcurrentHashMap<SubordinateXidImple, AtomicReference<TransactionImple>> _transactions = new ConcurrentHashMap();

    @Override
    public SubordinateTransaction importTransaction(Xid xid) throws XAException {
        return (SubordinateTransaction)this.importRemoteTransaction(xid, 0).getTransaction();
    }

    @Override
    public SubordinateTransaction importTransaction(Xid xid, int timeout) throws XAException {
        return (SubordinateTransaction)this.importRemoteTransaction(xid, timeout).getTransaction();
    }

    @Override
    public TransactionImportResult importRemoteTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException(jtaLogger.i18NLogger.get_error_xid_is_null());
        }
        return this.addImportedTransaction(null, this.convertXid(xid), xid, timeout);
    }

    @Override
    public TransactionImple recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException(jtaLogger.i18NLogger.get_error_imported_transaction_uid_is_null());
        }
        TransactionImple recovered = new TransactionImple(actId);
        if (recovered.baseXid() == null) {
            throw new IllegalArgumentException(jtaLogger.i18NLogger.get_error_imported_transaction_base_id_is_null(actId, recovered));
        }
        return (TransactionImple)this.addImportedTransaction(recovered, recovered.baseXid(), null, 0).getTransaction();
    }

    @Override
    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        TransactionImple tx2;
        if (xid == null) {
            throw new IllegalArgumentException(jtaLogger.i18NLogger.get_error_xid_is_null());
        }
        AtomicReference<TransactionImple> holder = _transactions.get(new SubordinateXidImple(xid));
        TransactionImple transactionImple = tx2 = holder == null ? null : holder.get();
        if (tx2 == null) {
            return null;
        }
        try {
            if (tx2.getStatus() == 4) {
                throw new XAException(100);
            }
        }
        catch (SystemException e) {
            jtaLogger.i18NLogger.error_failed_to_get_transaction_status(tx2, (Exception)((Object)e));
            throw new XAException(100);
        }
        if (!tx2.activated()) {
            tx2.recover();
            return tx2;
        }
        return tx2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException(jtaLogger.i18NLogger.get_error_xid_is_null());
        }
        AtomicReference<TransactionImple> remove = _transactions.remove(new SubordinateXidImple(xid));
        if (remove != null) {
            AtomicReference<TransactionImple> atomicReference = remove;
            synchronized (atomicReference) {
                TransactionImple transactionImple = remove.get();
                while (transactionImple == null) {
                    try {
                        remove.wait();
                        transactionImple = remove.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new XAException(-7);
                    }
                }
                TransactionImple.removeTransaction(transactionImple);
            }
        }
    }

    public Set<Xid> getInflightXids(String parentNodeName) {
        Iterator<AtomicReference<TransactionImple>> iterator = _transactions.values().iterator();
        HashSet<Xid> toReturn = new HashSet<Xid>();
        while (iterator.hasNext()) {
            AtomicReference<TransactionImple> holder = iterator.next();
            TransactionImple imported = holder.get();
            if (imported == null || !imported.getParentNodeName().equals(parentNodeName)) continue;
            toReturn.add(imported.baseXid());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionImportResult addImportedTransaction(TransactionImple recoveredTransaction, Xid mapKey, Xid xid, int timeout) {
        AtomicReference<TransactionImple> atomicReference;
        boolean isNew = false;
        SubordinateXidImple importedXid = new SubordinateXidImple(mapKey);
        AtomicReference<TransactionImple> holder = new AtomicReference<TransactionImple>();
        AtomicReference existing = _transactions.putIfAbsent(importedXid, holder);
        if (existing != null) {
            holder = existing;
        }
        TransactionImple txn = (TransactionImple)holder.get();
        if (recoveredTransaction != null) {
            atomicReference = holder;
            synchronized (atomicReference) {
                recoveredTransaction.recordTransaction();
                txn = recoveredTransaction;
                holder.set(txn);
                holder.notifyAll();
            }
        }
        if (txn == null) {
            atomicReference = holder;
            synchronized (atomicReference) {
                txn = (TransactionImple)holder.get();
                if (txn == null) {
                    txn = new TransactionImple(timeout, xid);
                    holder.set(txn);
                    holder.notifyAll();
                    isNew = true;
                }
            }
        }
        return new TransactionImportResult((ImportedTransaction)txn, isNew);
    }

    private XidImple convertXid(Xid xid) {
        if (xid != null && xid.getFormatId() == 131077) {
            XidImple toImport = new XidImple(xid);
            XATxConverter.setSubordinateNodeName(toImport.getXID(), TxControl.getXANodeName());
            return new SubordinateXidImple(toImport);
        }
        return new XidImple(xid);
    }
}

