/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jboss.marshalling.SerializabilityChecker;

public class IdentitySerializabilityChecker
implements SerializabilityChecker {
    private final Set<Class<?>> classes;

    public IdentitySerializabilityChecker(Collection<Class<?>> classes) {
        this.classes = Collections.newSetFromMap(new IdentityHashMap(classes.size()));
        this.classes.addAll(classes);
    }

    public boolean isSerializable(Class<?> targetClass) {
        return targetClass != Object.class && (this.classes.contains(targetClass) || DEFAULT.isSerializable(targetClass));
    }
}

