/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceNotFoundException;
import org.wildfly.clustering.server.manager.Service;
import org.wildfly.clustering.service.CountDownLifecycleListener;

public class ServiceControllerService
implements Service {
    private final ServiceController<?> controller;

    public ServiceControllerService(ServiceController<?> controller) {
        this.controller = controller;
    }

    public boolean isStarted() {
        return this.controller.getState() == ServiceController.State.UP;
    }

    public void start() {
        this.transition(Transition.START);
    }

    public void stop() {
        this.transition(Transition.STOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transition(Transition transition) {
        if (this.isComplete(transition)) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLifecycleListener listener = new CountDownLifecycleListener(latch, transition.targetEvents);
        this.controller.addListener((LifecycleListener)listener);
        try {
            if (this.isComplete(transition)) {
                return;
            }
            ServiceController.Mode currentMode = this.controller.getMode();
            if (currentMode == ServiceController.Mode.REMOVE) {
                throw new IllegalStateException((Throwable)new ServiceNotFoundException(this.controller.toString()));
            }
            ServiceController.Mode targetMode = transition.modeTransitions.get(currentMode);
            if (targetMode == null) {
                throw new IllegalStateException(currentMode.name());
            }
            this.controller.setMode(targetMode);
            latch.await();
            if (this.controller.getState() == ServiceController.State.START_FAILED) {
                throw new IllegalStateException((Throwable)this.controller.getStartException());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.controller.removeListener((LifecycleListener)listener);
        }
    }

    private boolean isComplete(Transition transition) {
        ServiceController.State state = this.controller.getState();
        if (transition.targetStates.contains(state)) {
            if (state == ServiceController.State.START_FAILED) {
                throw new IllegalStateException((Throwable)this.controller.getStartException());
            }
            return true;
        }
        return false;
    }

    private static enum Transition {
        START(EnumSet.of(ServiceController.State.UP, ServiceController.State.START_FAILED, ServiceController.State.REMOVED), LifecycleEvent.DOWN),
        STOP(EnumSet.of(ServiceController.State.DOWN, ServiceController.State.REMOVED), LifecycleEvent.UP);

        Set<ServiceController.State> targetStates;
        Set<LifecycleEvent> targetEvents;
        Map<ServiceController.Mode, ServiceController.Mode> modeTransitions;

        private Transition(Set<ServiceController.State> targetStates, LifecycleEvent sourceEvent) {
            this.targetStates = targetStates;
            this.targetEvents = EnumSet.complementOf(EnumSet.of(sourceEvent));
            this.modeTransitions = new EnumMap<ServiceController.Mode, ServiceController.Mode>(ServiceController.Mode.class);
            boolean up = this.targetStates.contains(ServiceController.State.UP);
            this.modeTransitions.put(up ? ServiceController.Mode.NEVER : ServiceController.Mode.ACTIVE, up ? ServiceController.Mode.ACTIVE : ServiceController.Mode.NEVER);
            this.modeTransitions.put(up ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.PASSIVE, up ? ServiceController.Mode.PASSIVE : ServiceController.Mode.ON_DEMAND);
        }
    }
}

