/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.SemanticAttributes;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaTrace;
import java.util.Collections;
import java.util.List;

public class KafkaAttributesExtractor
implements AttributesExtractor<KafkaTrace, Void> {
    private final MessagingAttributesGetter<KafkaTrace, Void> messagingAttributesGetter = new KafkaMessagingAttributesGetter();

    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaTrace kafkaTrace) {
        if (kafkaTrace.getPartition() != -1) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_PARTITION, kafkaTrace.getPartition());
        }
        if (kafkaTrace.getOffset() != -1L) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)kafkaTrace.getOffset());
        }
        String groupId = kafkaTrace.getGroupId();
        String clientId = kafkaTrace.getClientId();
        if (groupId != null && clientId != null) {
            Object consumerId = groupId;
            if (!clientId.isEmpty()) {
                consumerId = (String)consumerId + " - " + clientId;
            }
            attributes.put(SemanticAttributes.MESSAGING_CONSUMER_ID, consumerId);
        }
        if (groupId != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_CONSUMER_GROUP, (Object)groupId);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaTrace kafkaTrace, Void unused, Throwable error) {
    }

    public MessagingAttributesGetter<KafkaTrace, Void> getMessagingAttributesGetter() {
        return this.messagingAttributesGetter;
    }

    private static final class KafkaMessagingAttributesGetter
    implements MessagingAttributesGetter<KafkaTrace, Void> {
        private KafkaMessagingAttributesGetter() {
        }

        public String getSystem(KafkaTrace kafkaTrace) {
            return "kafka";
        }

        public String getDestination(KafkaTrace kafkaTrace) {
            return kafkaTrace.getTopic();
        }

        public boolean isTemporaryDestination(KafkaTrace kafkaTrace) {
            return false;
        }

        public String getConversationId(KafkaTrace kafkaTrace) {
            return null;
        }

        public String getMessageId(KafkaTrace kafkaTrace, Void unused) {
            return null;
        }

        public List<String> getMessageHeader(KafkaTrace kafkaTrace, String name) {
            return Collections.emptyList();
        }

        public String getDestinationTemplate(KafkaTrace kafkaTrace) {
            return null;
        }

        public boolean isAnonymousDestination(KafkaTrace kafkaTrace) {
            return false;
        }

        public Long getMessageBodySize(KafkaTrace kafkaTrace) {
            return null;
        }

        public Long getMessageEnvelopeSize(KafkaTrace kafkaTrace) {
            return null;
        }

        public String getClientId(KafkaTrace kafkaTrace) {
            if (kafkaTrace.getClientId() == null) {
                return null;
            }
            return kafkaTrace.getClientId();
        }

        public Long getBatchMessageCount(KafkaTrace kafkaTrace, Void unused) {
            return null;
        }
    }
}

