/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import java.util.Iterator;
import java.util.function.Function;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jaxrs.JaxrsAttribute;
import org.jboss.as.jaxrs.JaxrsServerConfig;
import org.jboss.as.jaxrs.deployment.JaxrsAnnotationProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsCdiIntegrationProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsComponentDeployer;
import org.jboss.as.jaxrs.deployment.JaxrsDependencyProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsIntegrationProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsMethodParameterProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsScanningProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsSpringProcessor;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.resteasy.spi.ResteasyDeployment;

class JaxrsSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final Function<ModelNode, String> LIST_TO_STRING = model -> {
        StringBuilder result = new StringBuilder();
        Iterator iterator = model.asList().iterator();
        while (iterator.hasNext()) {
            result.append(((ModelNode)iterator.next()).asString());
            if (!iterator.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    };
    private static final Function<ModelNode, String> MAP_TO_STRING = model -> {
        StringBuilder result = new StringBuilder();
        Iterator iterator = model.asPropertyList().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            result.append(property.getName()).append(':').append(property.getValue().asString());
            if (!iterator.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    };

    JaxrsSubsystemAdd() {
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        final ServiceTarget serviceTarget = context.getServiceTarget();
        JaxrsLogger.JAXRS_LOGGER.resteasyVersion(ResteasyDeployment.class.getPackage().getImplementationVersion());
        final JaxrsServerConfig contextConfiguration = JaxrsSubsystemAdd.createServerConfig(operation, context);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("jaxrs", Phase.PARSE, 10752, (DeploymentUnitProcessor)new JaxrsAnnotationProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.DEPENDENCIES, 3456, (DeploymentUnitProcessor)new JaxrsSpringProcessor(serviceTarget));
                processorTarget.addDeploymentProcessor("jaxrs", Phase.DEPENDENCIES, 3328, (DeploymentUnitProcessor)new JaxrsDependencyProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 6656, (DeploymentUnitProcessor)new JaxrsScanningProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 6912, (DeploymentUnitProcessor)new JaxrsComponentDeployer());
                CapabilityServiceSupport capabilities = context.getCapabilityServiceSupport();
                if (capabilities.hasCapability("org.wildfly.weld")) {
                    processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 7168, (DeploymentUnitProcessor)new JaxrsCdiIntegrationProcessor());
                }
                processorTarget.addDeploymentProcessor("jaxrs", Phase.POST_MODULE, 7200, (DeploymentUnitProcessor)new JaxrsMethodParameterProcessor());
                processorTarget.addDeploymentProcessor("jaxrs", Phase.INSTALL, 5376, (DeploymentUnitProcessor)new JaxrsIntegrationProcessor(contextConfiguration));
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private static JaxrsServerConfig createServerConfig(ModelNode configuration, OperationContext context) throws OperationFailedException {
        JaxrsServerConfig config = new JaxrsServerConfig();
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.JAXRS_2_0_REQUEST_MATCHING, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_ADD_CHARSET, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_BUFFER_EXCEPTION_ENTITY, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_DISABLE_HTML_SANITIZER, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_DISABLE_PROVIDERS, context, configuration, LIST_TO_STRING);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_EXPAND_ENTITY_REFERENCES, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_DISABLE_DTDS, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_PROCESSING_FEATURE, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_GZIP_MAX_INPUT, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_JNDI_RESOURCES, context, configuration, LIST_TO_STRING);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_LANGUAGE_MAPPINGS, context, configuration, MAP_TO_STRING);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_MEDIA_TYPE_MAPPINGS, context, configuration, MAP_TO_STRING);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_MEDIA_TYPE_PARAM_MAPPING, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_PATCHFILTER_DISABLED, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, "resteasy.preferJacksonOverJsonB", (AttributeDefinition)JaxrsAttribute.RESTEASY_PREFER_JACKSON_OVER_JSONB, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_PROVIDERS, context, configuration, LIST_TO_STRING);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_RFC7232_PRECONDITIONS, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_ROLE_BASED_SECURITY, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_SECURE_RANDOM_MAX_USE, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_USE_BUILTIN_PROVIDERS, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_USE_CONTAINER_FORM_PARAMS, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, (AttributeDefinition)JaxrsAttribute.RESTEASY_WIDER_REQUEST_MATCHING, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, "resteasy.server.tracing.threshold", (AttributeDefinition)JaxrsAttribute.TRACING_THRESHOLD, context, configuration);
        JaxrsSubsystemAdd.addContextParameter(config, "resteasy.server.tracing.type", (AttributeDefinition)JaxrsAttribute.TRACING_TYPE, context, configuration);
        return config;
    }

    private static void addContextParameter(JaxrsServerConfig config, AttributeDefinition attribute, OperationContext context, ModelNode model) throws OperationFailedException {
        JaxrsSubsystemAdd.addContextParameter(config, attribute, context, model, ModelNode::asString);
    }

    private static void addContextParameter(JaxrsServerConfig config, String contextName, AttributeDefinition attribute, OperationContext context, ModelNode model) throws OperationFailedException {
        JaxrsSubsystemAdd.addContextParameter(config, contextName, attribute, context, model, ModelNode::asString);
    }

    private static void addContextParameter(JaxrsServerConfig config, AttributeDefinition attribute, OperationContext context, ModelNode model, Function<ModelNode, String> valueMapper) throws OperationFailedException {
        if (model.hasDefined(attribute.getName())) {
            String name = attribute.getXmlName().replace('-', '.');
            JaxrsSubsystemAdd.addContextParameter(config, name, valueMapper.apply(attribute.resolveModelAttribute(context, model)));
        }
    }

    private static void addContextParameter(JaxrsServerConfig config, String contextName, AttributeDefinition attribute, OperationContext context, ModelNode model, Function<ModelNode, String> valueMapper) throws OperationFailedException {
        if (model.hasDefined(attribute.getName())) {
            String name = contextName == null ? attribute.getXmlName().replace('-', '.') : contextName;
            JaxrsSubsystemAdd.addContextParameter(config, name, valueMapper.apply(attribute.resolveModelAttribute(context, model)));
        }
    }

    private static void addContextParameter(JaxrsServerConfig config, String name, String value) {
        config.putContextParameter(name, value);
    }
}

