/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.function.Function;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.JaasSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

@Deprecated
public class JaasCustomSecurityRealmWrapper
implements SecurityRealm {
    private JaasSecurityRealm jaasSecurityRealm;

    public void initialize(Map<String, String> configuration) throws StartException {
        ClassLoader classLoader;
        String entry = configuration.get("entry");
        if (entry == null || entry.isEmpty()) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.jaasEntryNotDefined();
        }
        String pathParam = configuration.get("path");
        String relativeToParam = configuration.get("relative-to");
        String moduleNameParam = configuration.get("module");
        String callbackHandlerName = configuration.get("callbackHandlerName");
        String rootPath = null;
        InjectedValue pathManagerInjector = new InjectedValue();
        if (pathParam != null) {
            FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
            File jaasConfigFile = pathResolver.path(pathParam).relativeTo(relativeToParam, (PathManager)pathManagerInjector.getOptionalValue()).resolve();
            if (!jaasConfigFile.exists()) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.jaasFileDoesNotExist(jaasConfigFile.getPath());
            }
            rootPath = jaasConfigFile.getPath();
        }
        CallbackHandler callbackhandler = null;
        try {
            classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(moduleNameParam));
            if (callbackHandlerName != null) {
                Class<?> typeClazz = classLoader.loadClass(callbackHandlerName);
                callbackhandler = (CallbackHandler)typeClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToLoadCallbackhandlerFromProvidedModule();
        }
        this.jaasSecurityRealm = new JaasSecurityRealm(entry, rootPath, classLoader, callbackhandler);
    }

    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        return this.jaasSecurityRealm.getRealmIdentity(principal);
    }

    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        return this.jaasSecurityRealm.getRealmIdentity(evidence);
    }

    public RealmIdentity getRealmIdentity(Evidence evidence, Function<Principal, Principal> principalTransformer) throws RealmUnavailableException {
        return this.jaasSecurityRealm.getRealmIdentity(evidence, principalTransformer);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.jaasSecurityRealm.getCredentialAcquireSupport(credentialType, algorithmName);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return this.jaasSecurityRealm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.jaasSecurityRealm.getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    public void handleRealmEvent(RealmEvent event) {
        this.jaasSecurityRealm.handleRealmEvent(event);
    }
}

