/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.undertow;

import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.jboss.logging.Logger;
import org.jboss.wsf.stack.cxf.addons.transports.undertow.UndertowServerEngine;

public class UndertowServerEngineFactory
implements BusLifeCycleListener {
    private static final Logger LOG = Logger.getLogger(UndertowServerEngineFactory.class);
    private static final Map<Integer, UndertowServerEngine> portMap = new HashMap<Integer, UndertowServerEngine>();
    private BusLifeCycleManager lifeCycleManager;
    private Bus bus;

    public UndertowServerEngineFactory(Bus b) {
        this.setBus(b);
    }

    @Resource(name="cxf")
    public final void setBus(Bus bus) {
        assert (this.bus == null || this.bus == bus);
        this.bus = bus;
        if (bus != null) {
            bus.setExtension((Object)this, UndertowServerEngineFactory.class);
            this.lifeCycleManager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
            if (null != this.lifeCycleManager) {
                this.lifeCycleManager.registerLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UndertowServerEngine retrieveHttpServerEngine(int port) {
        UndertowServerEngine engine = null;
        Map<Integer, UndertowServerEngine> map = portMap;
        synchronized (map) {
            engine = portMap.get(port);
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UndertowServerEngine createHttpServerEngine(String host, int port, String protocol) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating HttpServer Engine for port " + port + "."));
        }
        UndertowServerEngine ref = null;
        Map<Integer, UndertowServerEngine> map = portMap;
        synchronized (map) {
            ref = this.retrieveHttpServerEngine(port);
            if (null == ref) {
                ref = new UndertowServerEngine(this, this.bus, host, port);
                portMap.put(port, ref);
            }
            if (!protocol.equals(ref.getProtocol())) {
                throw new IOException("Protocol mismatch for port " + port + ": engine's protocol is " + ref.getProtocol() + ", the url protocol is " + protocol);
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyForPort(int port) {
        Map<Integer, UndertowServerEngine> map = portMap;
        synchronized (map) {
            UndertowServerEngine ref = portMap.remove(port);
            if (ref != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stopping HttpServer Engine on port " + port + "."));
                }
                try {
                    ref.stop();
                }
                catch (Exception e) {
                    LOG.warn((Object)"", (Throwable)e);
                }
            }
        }
    }

    public void initComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postShutdown() {
        UndertowServerEngine[] engines = null;
        UndertowServerEngine[] undertowServerEngineArray = portMap;
        synchronized (portMap) {
            engines = portMap.values().toArray(new UndertowServerEngine[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (UndertowServerEngine engine : engines) {
                if (engine.getBus() != this.getBus()) continue;
                engine.shutdown();
            }
            return;
        }
    }

    public void preShutdown() {
    }
}

