/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.ba.remote;

import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.model.sagas.api.CoordinatorManager;
import com.arjuna.mw.wscf11.model.sagas.CoordinatorManagerFactory;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.BAParticipantManager;
import javax.xml.namespace.QName;

public class BAParticipantManagerImple
implements BAParticipantManager {
    private CoordinatorManager _coordManager = null;
    private ActivityHierarchy _hier = null;
    private String _participantId = null;

    public BAParticipantManagerImple(String participantId) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)(this.getClass().getSimpleName() + " constructor. Participant id: " + participantId));
        }
        try {
            this._coordManager = CoordinatorManagerFactory.coordinatorManager();
            this._hier = this._coordManager.currentActivity();
            this._participantId = participantId;
        }
        catch (Exception ex) {
            wstxLogger.i18NLogger.warn_unexpectedExcpetion(ex);
        }
    }

    @Override
    public void exit() throws WrongStateException, UnknownTransactionException, com.arjuna.wst.SystemException {
        try {
            if (wstxLogger.logger.isTraceEnabled()) {
                wstxLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".exit. Participant id: " + this._participantId));
            }
            if (this._hier == null) {
                throw new UnknownTransactionException();
            }
            this._coordManager.resume(this._hier);
            this._coordManager.delistParticipant(this._participantId);
            this._coordManager.suspend();
        }
        catch (NoActivityException ex) {
            throw new UnknownTransactionException();
        }
        catch (InvalidParticipantException ex) {
            throw new com.arjuna.wst.SystemException("UnknownParticipantException");
        }
        catch (com.arjuna.mw.wsas.exceptions.WrongStateException ex) {
            throw new WrongStateException();
        }
        catch (InvalidActivityException ex) {
            throw new UnknownTransactionException();
        }
        catch (SystemException ex) {
            throw new com.arjuna.wst.SystemException(ex.toString());
        }
    }

    @Override
    public void completed() throws WrongStateException, UnknownTransactionException, com.arjuna.wst.SystemException {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".completed. Participant id: " + this._participantId));
        }
        try {
            if (this._hier == null) {
                throw new UnknownTransactionException();
            }
            this._coordManager.resume(this._hier);
            this._coordManager.participantCompleted(this._participantId);
            this._coordManager.suspend();
        }
        catch (NoActivityException ex) {
            throw new UnknownTransactionException();
        }
        catch (InvalidParticipantException ex) {
            throw new com.arjuna.wst.SystemException("UnknownParticipantException");
        }
        catch (com.arjuna.mw.wsas.exceptions.WrongStateException ex) {
            throw new WrongStateException();
        }
        catch (InvalidActivityException ex) {
            throw new UnknownTransactionException();
        }
        catch (SystemException ex) {
            throw new com.arjuna.wst.SystemException(ex.toString());
        }
    }

    @Override
    public void fail(QName exceptionIdentifier) throws com.arjuna.wst.SystemException {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".fail. Participant id: " + this._participantId + ", exceptionIdentifier: " + exceptionIdentifier));
        }
        try {
            if (this._hier == null) {
                throw new UnknownTransactionException();
            }
            this._coordManager.resume(this._hier);
            this._coordManager.participantFaulted(this._participantId);
            this._coordManager.suspend();
        }
        catch (InvalidActivityException iae) {
            throw new com.arjuna.wst.SystemException("UnknownTransactionException");
        }
        catch (UnknownTransactionException ute) {
            throw new com.arjuna.wst.SystemException("UnknownTransactionException");
        }
        catch (InvalidParticipantException ex) {
            throw new com.arjuna.wst.SystemException("UnknownParticipantException");
        }
        catch (NoActivityException ex) {
            throw new com.arjuna.wst.SystemException("UnknownTransactionException");
        }
        catch (SystemException ex) {
            throw new com.arjuna.wst.SystemException(ex.toString());
        }
    }

    @Override
    public void cannotComplete() throws WrongStateException, UnknownTransactionException, com.arjuna.wst.SystemException {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".cannotComplete. Participant id: " + this._participantId));
        }
        try {
            if (this._hier == null) {
                throw new UnknownTransactionException();
            }
            this._coordManager.resume(this._hier);
            this._coordManager.participantCannotComplete(this._participantId);
            this._coordManager.suspend();
        }
        catch (InvalidActivityException iae) {
            throw new com.arjuna.wst.SystemException("UnknownTransactionException");
        }
        catch (UnknownTransactionException ute) {
            throw new com.arjuna.wst.SystemException("UnknownTransactionException");
        }
        catch (InvalidParticipantException ex) {
            throw new com.arjuna.wst.SystemException("UnknownParticipantException");
        }
        catch (com.arjuna.mw.wsas.exceptions.WrongStateException ex) {
            throw new WrongStateException();
        }
        catch (NoActivityException ex) {
            throw new com.arjuna.wst.SystemException("UnknownTransactionException");
        }
        catch (SystemException ex) {
            throw new com.arjuna.wst.SystemException(ex.toString());
        }
    }

    public void error() throws com.arjuna.wst.SystemException {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".error. Participant id: " + this._participantId));
        }
        try {
            this._coordManager.setCancelOnly();
        }
        catch (com.arjuna.mw.wsas.exceptions.WrongStateException ex) {
            throw new com.arjuna.wst.SystemException(ex.toString());
        }
        catch (SystemException ex) {
            throw new com.arjuna.wst.SystemException(ex.toString());
        }
    }
}

