/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.client.CompletionInitiatorClient;
import com.arjuna.webservices11.wsat.processors.CompletionCoordinatorProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.CompletionCoordinatorParticipant;
import java.text.MessageFormat;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CompletionCoordinatorProcessorImpl
extends CompletionCoordinatorProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateParticipant(CompletionCoordinatorParticipant participant, String identifier) {
        this.activatedObjectProcessor.activateObject(participant, identifier);
    }

    @Override
    public void deactivateParticipant(CompletionCoordinatorParticipant participant) {
        this.activatedObjectProcessor.deactivateObject(participant);
    }

    private CompletionCoordinatorParticipant getParticipant(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return (CompletionCoordinatorParticipant)this.activatedObjectProcessor.getObject(identifier);
    }

    @Override
    public void commit(Notification commit, MAP map, ArjunaContext arjunaContext) {
        block13: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            CompletionCoordinatorParticipant participant = this.getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.commit();
                    }
                    catch (TransactionRolledBackException trbe) {
                        MAP responseAddressingContext = AddressingHelper.createResponseContext(map, messageId);
                        CompletionInitiatorClient.getClient().sendAborted(participant.getParticipant(), responseAddressingContext, instanceIdentifier);
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev((Throwable)trbe, "Participant {0} commit failed to be aborted on instance {1}", (Object)participant.getParticipant(), (Object)instanceIdentifier);
                        }
                        return;
                    }
                    catch (UnknownTransactionException ute) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_1());
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, soapFault, instanceIdentifier);
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev((Throwable)ute, "Participant {0} commit unknown failure on instance {1}: {2}", new Object[]{participant.getParticipant(), instanceIdentifier, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_1(), ute});
                        }
                        return;
                    }
                    catch (SystemException se) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext(map, messageId);
                        String pattern = WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_2();
                        String message = MessageFormat.format(pattern, se);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME, message);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, soapFault, instanceIdentifier);
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev((Throwable)se, "Participant {0} commit system failure on instance {1}: {2}", (Object)participant.getParticipant(), (Object)instanceIdentifier, (Object)WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_1());
                        }
                        return;
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev(th, "Unexpected exception thrown from commit for participant {0} on instance {1}", (Object)participant.getParticipant(), (Object)instanceIdentifier);
                        }
                        MAP faultAddressingContext = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                        SoapFault11 soapFault = new SoapFault11(th);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, soapFault, instanceIdentifier);
                        return;
                    }
                    MAP responseAddressingContext = AddressingHelper.createResponseContext(map, messageId);
                    CompletionInitiatorClient.getClient().sendCommitted(participant.getParticipant(), responseAddressingContext, instanceIdentifier);
                    break block13;
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Commit called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                MAP faultAddressingContext = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_5());
                CompletionInitiatorClient.getClient().sendSoapFault(faultAddressingContext, soapFault, instanceIdentifier);
            }
            catch (Throwable throwable) {
                WSTLogger.logger.warn((Object)throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public void rollback(Notification rollback, MAP map, ArjunaContext arjunaContext) {
        block9: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            CompletionCoordinatorParticipant participant = this.getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.rollback();
                    }
                    catch (UnknownTransactionException ute) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_6());
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (SystemException systemException) {
                        MAP faultAddressingContext = AddressingHelper.createFaultContext(map, messageId);
                        String message = WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_7();
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME, message);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from rollback:", (Object)th);
                        }
                        MAP faultAddressingContext = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                        SoapFault11 soapFault = new SoapFault11(th);
                        CompletionInitiatorClient.getClient().sendSoapFault(participant.getParticipant(), faultAddressingContext, soapFault, instanceIdentifier);
                        return;
                    }
                    MAP responseAddressingContext = AddressingHelper.createResponseContext(map, messageId);
                    CompletionInitiatorClient.getClient().sendAborted(participant.getParticipant(), responseAddressingContext, instanceIdentifier);
                    break block9;
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Rollback called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                MAP faultAddressingContext = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_CompletionCoordinatorProcessorImpl_10());
                CompletionInitiatorClient.getClient().sendSoapFault(faultAddressingContext, soapFault, instanceIdentifier);
            }
            catch (Throwable throwable) {
                WSTLogger.logger.warn((Object)throwable.getMessage(), throwable);
            }
        }
    }
}

