/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class ElasticsearchByMappedTypeProjection<P>
extends AbstractElasticsearchProjection<P> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ProjectionExtractionHelper<String> mappedTypeNameHelper;
    private final Map<String, ElasticsearchSearchProjection<? extends P>> inners;

    public ElasticsearchByMappedTypeProjection(ElasticsearchSearchIndexScope<?> scope, ProjectionExtractionHelper<String> mappedTypeNameHelper, Map<String, ElasticsearchSearchProjection<? extends P>> inners) {
        super(scope);
        this.mappedTypeNameHelper = mappedTypeNameHelper;
        this.inners = inners;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inners=" + String.valueOf(this.inners) + "]";
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, P> request(JsonObject requestBody, ProjectionRequestContext context) {
        HashMap innerExtractors = new HashMap();
        for (Map.Entry<String, ElasticsearchSearchProjection<P>> entry : this.inners.entrySet()) {
            innerExtractors.put(entry.getKey(), entry.getValue().request(requestBody, context));
        }
        return new ByMappedTypeExtractor(innerExtractors);
    }

    private final class ByMappedTypeExtractor
    implements ElasticsearchSearchProjection.Extractor<DelegateAndExtractedValue<?, P>, P> {
        private final Map<String, ElasticsearchSearchProjection.Extractor<?, ? extends P>> inners;

        private ByMappedTypeExtractor(Map<String, ElasticsearchSearchProjection.Extractor<?, ? extends P>> inners) {
            this.inners = inners;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inners=" + String.valueOf(this.inners) + "]";
        }

        @Override
        public DelegateAndExtractedValue<?, P> extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
            String typeName = ElasticsearchByMappedTypeProjection.this.mappedTypeNameHelper.extract(hit, context);
            ElasticsearchSearchProjection.Extractor inner = this.inners.get(typeName);
            if (inner == null) {
                throw log.unexpectedMappedTypeNameForByMappedTypeProjection(typeName, this.inners.keySet());
            }
            return new DelegateAndExtractedValue(inner, projectionHitMapper, hit, source, context);
        }

        @Override
        public P transform(LoadingResult<?> loadingResult, DelegateAndExtractedValue<?, P> extracted, ProjectionTransformContext context) {
            return extracted.transform(loadingResult, context);
        }
    }

    private static final class DelegateAndExtractedValue<E, P> {
        private final ElasticsearchSearchProjection.Extractor<E, ? extends P> delegate;
        private final E extractedValue;

        private DelegateAndExtractedValue(ElasticsearchSearchProjection.Extractor<E, ? extends P> delegate, ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
            this.delegate = delegate;
            this.extractedValue = delegate.extract(projectionHitMapper, hit, source, context);
        }

        P transform(LoadingResult<?> loadingResult, ProjectionTransformContext context) {
            return this.delegate.transform(loadingResult, this.extractedValue, context);
        }
    }
}

