/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.cfg.spi.NumberScaleConstants;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchBigDecimalFieldCodec
extends AbstractElasticsearchFieldCodec<BigDecimal> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final int decimalScale;
    private final BigDecimal scalingFactor;
    private final BigDecimal minScaledValue;
    private final BigDecimal maxScaledValue;

    public ElasticsearchBigDecimalFieldCodec(Gson gson, int decimalScale) {
        super(gson);
        this.decimalScale = decimalScale;
        this.scalingFactor = BigDecimal.TEN.pow(decimalScale, new MathContext(10, RoundingMode.HALF_UP));
        this.minScaledValue = new BigDecimal(NumberScaleConstants.MIN_LONG_AS_BIGINTEGER, decimalScale);
        this.maxScaledValue = new BigDecimal(NumberScaleConstants.MAX_LONG_AS_BIGINTEGER, decimalScale);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[decimalScale=" + this.decimalScale + "]";
    }

    @Override
    public JsonElement encode(BigDecimal value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (value.compareTo(this.minScaledValue) < 0 || value.compareTo(this.maxScaledValue) > 0) {
            throw log.scaledNumberTooLarge(value, this.minScaledValue, this.maxScaledValue);
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public BigDecimal decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BIG_DECIMAL.fromElement(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchBigDecimalFieldCodec other = (ElasticsearchBigDecimalFieldCodec)obj;
        return this.decimalScale == other.decimalScale;
    }

    public BigDecimal scalingFactor() {
        return this.scalingFactor;
    }
}

