/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.appclient.component.ApplicationClientComponentDescription;
import org.jboss.as.appclient.deployment.AppClientAttachments;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.deployers.DescriptorEnvironmentLifecycleMethodProcessor;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;

public class ApplicationClientManifestProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String mainClass;
        Attributes main;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Manifest manifest = (Manifest)root.getAttachment(org.jboss.as.server.deployment.Attachments.MANIFEST);
        if (manifest != null && (main = manifest.getMainAttributes()) != null && (mainClass = main.getValue("Main-Class")) != null && !mainClass.isEmpty()) {
            Class clazz;
            try {
                clazz = module.getClassLoader().loadClass(mainClass);
            }
            catch (Throwable e) {
                throw AppClientLogger.ROOT_LOGGER.cannotLoadAppClientMainClass(e);
            }
            deploymentUnit.putAttachment(AppClientAttachments.MAIN_CLASS, (Object)clazz);
            ApplicationClientComponentDescription description = new ApplicationClientComponentDescription(clazz.getName(), moduleDescription, deploymentUnit.getServiceName());
            moduleDescription.addComponent((ComponentDescription)description);
            deploymentUnit.putAttachment(AppClientAttachments.APPLICATION_CLIENT_COMPONENT, (Object)description);
            DeploymentDescriptorEnvironment environment = (DeploymentDescriptorEnvironment)deploymentUnit.getAttachment(Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT);
            if (environment != null) {
                DescriptorEnvironmentLifecycleMethodProcessor.handleMethods((DeploymentDescriptorEnvironment)environment, (EEModuleDescription)moduleDescription, (String)mainClass);
            }
        }
    }
}

