/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import jakarta.servlet.Servlet;
import java.io.File;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.msc.service.StartException;

public class WebAppController {
    private WebHost host;
    private String contextRoot;
    private String urlPattern;
    private String serverTempDir;
    private String servletClass;
    private ClassLoader classloader;
    private volatile WebDeploymentController ctx;
    private int count = 0;

    public WebAppController(WebHost host, String servletClass, ClassLoader classloader, String contextRoot, String urlPattern, String serverTempDir) {
        this.host = host;
        this.contextRoot = contextRoot;
        this.urlPattern = urlPattern;
        this.serverTempDir = serverTempDir;
        this.classloader = classloader;
        this.servletClass = servletClass;
    }

    public synchronized int incrementUsers() throws StartException {
        if (this.count == 0) {
            try {
                this.ctx = this.startWebApp(this.host);
            }
            catch (Exception e) {
                throw new StartException((Throwable)e);
            }
        }
        return this.count++;
    }

    public synchronized int decrementUsers() {
        if (this.count == 0) {
            throw new IllegalStateException();
        }
        --this.count;
        if (this.count == 0) {
            try {
                this.stopWebApp(this.ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.count;
    }

    private WebDeploymentController startWebApp(WebHost host) throws Exception {
        WebDeploymentController deployment;
        WebDeploymentBuilder builder = new WebDeploymentBuilder();
        try {
            builder.setContextRoot(this.contextRoot);
            File docBase = new File(this.serverTempDir, this.contextRoot);
            if (!docBase.exists()) {
                docBase.mkdirs();
            }
            builder.setDocumentRoot(docBase);
            builder.setClassLoader(this.classloader);
            int j = this.servletClass.indexOf(".");
            String servletName = j < 0 ? this.servletClass : this.servletClass.substring(j + 1);
            Class<?> clazz = this.classloader.loadClass(this.servletClass);
            ServletBuilder servlet = new ServletBuilder();
            servlet.setServletName(servletName);
            servlet.setServlet((Servlet)clazz.newInstance());
            servlet.setServletClass(clazz);
            servlet.addUrlMapping(this.urlPattern);
            builder.addServlet(servlet);
            deployment = host.addWebDeployment(builder);
            deployment.create();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.createContextPhaseFailed(e);
        }
        try {
            deployment.start();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.startContextPhaseFailed(e);
        }
        return deployment;
    }

    private void stopWebApp(WebDeploymentController context) throws Exception {
        try {
            context.stop();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.stopContextPhaseFailed(e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.destroyContextPhaseFailed(e);
        }
    }
}

