/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.provider;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.clustering.server.local.LocalGroup;
import org.wildfly.clustering.server.local.LocalGroupMember;
import org.wildfly.clustering.server.local.provider.DefaultServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderListener;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrar;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;

public interface LocalServiceProviderRegistrar<T>
extends ServiceProviderRegistrar<T, LocalGroupMember> {
    public LocalGroup getGroup();

    public static <T> LocalServiceProviderRegistrar<T> of(final LocalGroup group) {
        final ConcurrentHashMap.KeySetView services = ConcurrentHashMap.newKeySet();
        return new LocalServiceProviderRegistrar<T>(){

            @Override
            public LocalGroup getGroup() {
                return group;
            }

            public ServiceProviderRegistration<T, LocalGroupMember> register(T service) {
                services.add(service);
                return new DefaultServiceProviderRegistration(this, service, () -> services.remove(service));
            }

            public ServiceProviderRegistration<T, LocalGroupMember> register(T service, ServiceProviderListener<LocalGroupMember> listener) {
                return this.register((T)service);
            }

            public Set<LocalGroupMember> getProviders(T service) {
                return services.contains(service) ? Set.of((LocalGroupMember)group.getLocalMember()) : Set.of();
            }

            public Set<T> getServices() {
                return Collections.unmodifiableSet(services);
            }
        };
    }
}

