/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.mgmt.DomainHostExcludeRegistry;
import org.jboss.as.version.ProductConfig;
import org.jboss.as.version.Stability;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class HostInfo
implements Transformers.ResourceIgnoredTransformationRegistry,
Transformers.OperationExcludedTransformationRegistry,
Feature {
    private final String hostName;
    private final String releaseVersion;
    private final String releaseCodeName;
    private final int managementMajorVersion;
    private final int managementMinorVersion;
    private final int managementMicroVersion;
    private final String productName;
    private final String productVersion;
    private final Long remoteConnectionId;
    private final Transformers.ResourceIgnoredTransformationRegistry ignoredResources;
    private final boolean ignoreUnaffectedConfig;
    private final Set<IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo> serverConfigInfos;
    private final Set<String> domainIgnoredExtensions;
    private final boolean hostDeclaredIgnoreUnaffected;
    private final Stability stability;
    private ReadMasterDomainModelUtil.RequiredConfigurationHolder requiredConfigurationHolder;

    public static ModelNode createLocalHostHostInfo(LocalHostControllerInfo hostInfo, ProductConfig productConfig, IgnoredDomainResourceRegistry ignoredResourceRegistry, Resource hostModelResource) {
        ModelNode ignoredModel;
        ModelNode info = new ModelNode();
        info.get("name").set(hostInfo.getLocalHostName());
        info.get("release-version").set(Version.AS_VERSION);
        info.get("release-codename").set(Version.AS_RELEASE_CODENAME);
        info.get("management-major-version").set(28);
        info.get("management-minor-version").set(0);
        info.get("management-micro-version").set(0);
        info.get("stability").set(hostInfo.getStability().name());
        String productName = productConfig.getProductName();
        String productVersion = productConfig.getProductVersion();
        if (productName != null) {
            info.get("product-name").set(productName);
        }
        if (productVersion != null) {
            info.get("product-version").set(productVersion);
        }
        if ((ignoredModel = ignoredResourceRegistry.getIgnoredResourcesAsModel()).hasDefined("ignored-resource-type")) {
            info.get("ignored-resources").set(ignoredModel.require("ignored-resource-type"));
        }
        boolean ignoreUnaffectedServerGroups = hostInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration();
        IgnoredNonAffectedServerGroupsUtil.addCurrentServerGroupsToHostInfoModel(ignoreUnaffectedServerGroups, hostModelResource, info);
        return info;
    }

    public static HostInfo fromModelNode(ModelNode hostInfo) {
        return HostInfo.fromModelNode(hostInfo, null);
    }

    public static HostInfo fromModelNode(ModelNode hostInfo, DomainHostExcludeRegistry hostIgnoreRegistry) {
        return new HostInfo(hostInfo, hostIgnoreRegistry);
    }

    private HostInfo(ModelNode hostInfo, DomainHostExcludeRegistry hostIgnoreRegistry) {
        this.hostName = hostInfo.require("name").asString();
        this.releaseVersion = hostInfo.require("release-version").asString();
        this.releaseCodeName = hostInfo.require("release-codename").asString();
        this.managementMajorVersion = hostInfo.require("management-major-version").asInt();
        this.managementMinorVersion = hostInfo.require("management-minor-version").asInt();
        this.managementMicroVersion = hostInfo.hasDefined("management-micro-version") ? hostInfo.require("management-micro-version").asInt() : 0;
        this.productName = hostInfo.hasDefined("product-name") ? hostInfo.require("product-name").asString() : null;
        this.productVersion = hostInfo.hasDefined("product-version") ? hostInfo.require("product-version").asString() : null;
        this.remoteConnectionId = hostInfo.hasDefined("domain-connection-id") ? Long.valueOf(hostInfo.get("domain-connection-id").asLong()) : null;
        this.stability = Optional.ofNullable(hostInfo.get("stability").asStringOrNull()).map(Stability::valueOf).orElse(Stability.DEFAULT);
        Set<String> domainIgnoredExtensions = null;
        Set<String> domainActiveServerGroups = null;
        Set<String> domainActiveSocketBindingGroups = null;
        if (hostIgnoreRegistry != null) {
            DomainHostExcludeRegistry.VersionExcludeData domainHostIgnoreData = hostIgnoreRegistry.getVersionIgnoreData(this.managementMajorVersion, this.managementMinorVersion, this.managementMicroVersion);
            if (domainHostIgnoreData != null) {
                domainIgnoredExtensions = domainHostIgnoreData.getExcludedExtensions();
                domainActiveServerGroups = domainHostIgnoreData.getActiveServerGroups();
                domainActiveSocketBindingGroups = domainHostIgnoreData.getActiveSocketBindingGroups();
            } else {
                DomainControllerLogger.ROOT_LOGGER.tracef("No VersionExcludeData for %d.%d.%d", this.managementMajorVersion, this.managementMinorVersion, this.managementMicroVersion);
            }
        } else {
            DomainControllerLogger.ROOT_LOGGER.trace("DomainHostExcludeRegistry is null");
        }
        this.domainIgnoredExtensions = domainIgnoredExtensions;
        this.ignoredResources = HostInfo.createIgnoredRegistry(hostInfo, domainIgnoredExtensions);
        this.hostDeclaredIgnoreUnaffected = hostInfo.hasDefined("ignore-unused-configuration") && hostInfo.get("ignore-unused-configuration").asBoolean();
        boolean bl = this.ignoreUnaffectedConfig = this.hostDeclaredIgnoreUnaffected || domainActiveServerGroups != null && !domainActiveServerGroups.isEmpty();
        Set<Object> serverConfigInfos = this.ignoreUnaffectedConfig ? (this.hostDeclaredIgnoreUnaffected ? IgnoredNonAffectedServerGroupsUtil.createConfigsFromModel(hostInfo) : IgnoredNonAffectedServerGroupsUtil.createConfigsFromDomainWideData(domainActiveServerGroups, domainActiveSocketBindingGroups)) : Collections.emptySet();
        this.serverConfigInfos = serverConfigInfos;
    }

    public Stability getStability() {
        return this.stability;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getReleaseCodeName() {
        return this.releaseCodeName;
    }

    public int getManagementMajorVersion() {
        return this.managementMajorVersion;
    }

    public int getManagementMinorVersion() {
        return this.managementMinorVersion;
    }

    public int getManagementMicroVersion() {
        return this.managementMicroVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public Long getRemoteConnectionId() {
        return this.remoteConnectionId;
    }

    public boolean isResourceTransformationIgnored(PathAddress address) {
        return this.ignoredResources.isResourceTransformationIgnored(address);
    }

    public boolean isIgnoreUnaffectedConfig() {
        return this.ignoreUnaffectedConfig;
    }

    public Set<IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo> getServerConfigInfos() {
        return this.serverConfigInfos;
    }

    public String getPrettyProductName() {
        String result = this.productName != null ? ProductConfig.getPrettyVersionString((String)this.productName, (String)this.productVersion, (String)this.releaseVersion) : ProductConfig.getPrettyVersionString(null, (String)this.releaseVersion, (String)this.releaseCodeName);
        return result;
    }

    public boolean isOperationExcluded(PathAddress address, String operationName) {
        if (address.size() > 0) {
            PathElement element = address.getElement(0);
            String type = element.getKey();
            String name = element.getValue();
            boolean domainExcluding = this.ignoreUnaffectedConfig && !this.hostDeclaredIgnoreUnaffected && this.requiredConfigurationHolder != null;
            switch (type) {
                case "extension": {
                    return this.domainIgnoredExtensions != null && this.domainIgnoredExtensions.contains(element.getValue());
                }
                case "profile": {
                    return domainExcluding && ("clone".equals(operationName) && address.size() == 1 || !this.requiredConfigurationHolder.getProfiles().contains(name));
                }
                case "server-group": {
                    return domainExcluding && !this.requiredConfigurationHolder.getServerGroups().contains(name);
                }
                case "socket-binding-group": {
                    return domainExcluding && ("clone".equals(operationName) && address.size() == 1 || !this.requiredConfigurationHolder.getSocketBindings().contains(name));
                }
            }
        }
        return false;
    }

    public synchronized ReadMasterDomainModelUtil.RequiredConfigurationHolder populateRequiredConfigurationHolder(Resource resource, ExtensionRegistry extensionRegistry) {
        if (this.requiredConfigurationHolder != null) {
            throw new IllegalStateException();
        }
        this.requiredConfigurationHolder = ReadMasterDomainModelUtil.populateHostResolutionContext(this, resource, extensionRegistry);
        return this.requiredConfigurationHolder;
    }

    public Set<String> getDomainIgnoredExtensions() {
        return this.domainIgnoredExtensions;
    }

    public static Transformers.ResourceIgnoredTransformationRegistry createIgnoredRegistry(ModelNode modelNode) {
        return HostInfo.createIgnoredRegistry(modelNode, null);
    }

    public static Transformers.ResourceIgnoredTransformationRegistry createIgnoredRegistry(ModelNode modelNode, Set<String> domainIgnoredExtensions) {
        final Map<String, IgnoredType> ignoredResources = HostInfo.processIgnoredResource(modelNode, domainIgnoredExtensions);
        return new Transformers.ResourceIgnoredTransformationRegistry(){

            public boolean isResourceTransformationIgnored(PathAddress address) {
                PathElement firstElement;
                IgnoredType ignoredType;
                return ignoredResources != null && address.size() > 0 && (ignoredType = (IgnoredType)ignoredResources.get((firstElement = address.getElement(0)).getKey())) != null && ignoredType.hasName(firstElement.getValue());
            }
        };
    }

    private static Map<String, IgnoredType> processIgnoredResource(ModelNode model, Set<String> domainIgnoredExtensions) {
        HashMap<String, IgnoredType> ignoredResources = null;
        if (model.hasDefined("ignored-resources")) {
            ignoredResources = new HashMap<String, IgnoredType>();
            for (Property prop : model.require("ignored-resources").asPropertyList()) {
                String type = prop.getName();
                ModelNode ignoredModel = prop.getValue();
                IgnoredType ignoredType = ignoredModel.get("wildcard").asBoolean(false) ? new IgnoredType() : new IgnoredType(ignoredModel.get("names"));
                ignoredResources.put(type, ignoredType);
            }
        }
        if (domainIgnoredExtensions != null && !domainIgnoredExtensions.isEmpty()) {
            IgnoredType slaveIgnoredExtensions = null;
            if (ignoredResources == null) {
                ignoredResources = new HashMap();
            } else {
                slaveIgnoredExtensions = (IgnoredType)ignoredResources.get("extension");
            }
            IgnoredType ignoredExtensions = new IgnoredType(slaveIgnoredExtensions, domainIgnoredExtensions);
            ignoredResources.put("extension", ignoredExtensions);
            DomainControllerLogger.ROOT_LOGGER.tracef("Ignoring extensions %s", ignoredExtensions.names);
        } else {
            DomainControllerLogger.ROOT_LOGGER.tracef("No domain ignored extensions: %s", domainIgnoredExtensions);
        }
        return ignoredResources;
    }

    private static class IgnoredType {
        private final boolean wildcard;
        private final Set<String> names;

        private IgnoredType() {
            this.wildcard = true;
            this.names = null;
        }

        private IgnoredType(ModelNode names) {
            this.wildcard = false;
            if (names.isDefined()) {
                this.names = new HashSet<String>();
                for (ModelNode name : names.asList()) {
                    this.names.add(name.asString());
                }
            } else {
                this.names = null;
            }
        }

        private IgnoredType(IgnoredType slaveIgnoredNames, Set<String> domainIgnoredNames) {
            this.wildcard = false;
            this.names = new HashSet<String>();
            if (slaveIgnoredNames != null && slaveIgnoredNames.names != null) {
                this.names.addAll(slaveIgnoredNames.names);
            }
            if (domainIgnoredNames != null) {
                this.names.addAll(domainIgnoredNames);
            }
        }

        private boolean hasName(String name) {
            return this.wildcard || this.names != null && this.names.contains(name);
        }
    }
}

