/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ContentIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Content, V, A, O, AB, OB> {
    private static final String[] EMPTY = new String[0];
    private static final String PROP_MEDIA_TYPE = "mediaType";

    public static String[] defaultMediaTypes() {
        return new String[]{"*/*"};
    }

    public ContentIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.CONTENT, Names.create(Content.class));
    }

    public Content read(AnnotationValue annotations, Direction direction) {
        return Optional.ofNullable(annotations).map(AnnotationValue::asNestedArray).map(annotationArray -> this.read((AnnotationInstance[])annotationArray, direction)).orElse(null);
    }

    private Content read(AnnotationInstance[] annotations, Direction direction) {
        IoLogging.logger.singleAnnotation("@Content");
        Content content = OASFactory.createContent();
        for (AnnotationInstance annotation : annotations) {
            String contentType = (String)this.value(annotation, PROP_MEDIA_TYPE);
            MediaType mediaTypeModel = this.mediaTypeIO().read(annotation);
            if (contentType == null) {
                for (String mimeType : this.getDefaultMimeTypes(direction)) {
                    content.addMediaType(mimeType, mediaTypeModel);
                }
                continue;
            }
            content.addMediaType(contentType, mediaTypeModel);
        }
        return content;
    }

    private String[] getDefaultMimeTypes(Direction direction) {
        switch (direction.ordinal()) {
            case 0: {
                return ContentIO.nonNullOrElse(this.scannerContext().getCurrentConsumes(), EMPTY);
            }
            case 1: {
                return ContentIO.nonNullOrElse(this.scannerContext().getCurrentProduces(), EMPTY);
            }
            case 2: {
                return ContentIO.defaultMediaTypes();
            }
        }
        return EMPTY;
    }

    static <T> T nonNullOrElse(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    @Override
    public Content read(AnnotationInstance annotation) {
        throw new UnsupportedOperationException("Reading a single @Content annotation is not supported");
    }

    public static enum Direction {
        INPUT,
        OUTPUT,
        PARAMETER;

    }
}

