/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.jta;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.ObserverMethod;
import java.lang.annotation.Annotation;
import org.jboss.weld.Container;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.module.jta.Status;
import org.jboss.weld.util.Observers;

class DeferredEventNotification<T>
implements Runnable {
    protected final ObserverMethod<? super T> observer;
    private final T event;
    protected final EventMetadata metadata;
    private final CurrentEventMetadata currentEventMetadata;
    private final String contextId;
    private final Status status;
    private final boolean before;

    public DeferredEventNotification(String contextId, T event, EventMetadata metadata, ObserverMethod<? super T> observer, CurrentEventMetadata currentEventMetadata, Status status, boolean before) {
        this.contextId = contextId;
        this.observer = observer;
        this.event = event;
        this.metadata = metadata;
        this.currentEventMetadata = currentEventMetadata;
        this.status = status;
        this.before = before;
    }

    @Override
    public void run() {
        try {
            EventLogger.LOG.asyncFire((Object)this.metadata, this.observer);
            new RunInRequest(this.contextId){

                @Override
                protected void execute() {
                    ThreadLocalStack.ThreadLocalStackReference stack = DeferredEventNotification.this.currentEventMetadata.pushIfNotNull((Object)DeferredEventNotification.this.metadata);
                    try {
                        Observers.notify(DeferredEventNotification.this.observer, (Object)DeferredEventNotification.this.event, (EventMetadata)DeferredEventNotification.this.metadata);
                    }
                    finally {
                        stack.pop();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            EventLogger.LOG.asyncObserverFailure(this.observer, (Object)this.metadata, (Object)(e.getCause() != null ? e.getCause() : e));
            EventLogger.LOG.catchingDebug((Throwable)e);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isBefore() {
        return this.before;
    }

    public String toString() {
        return "Deferred event [" + this.event + "] for [" + this.observer + "]";
    }

    private static abstract class RunInRequest {
        private final String contextId;

        public RunInRequest(String contextId) {
            this.contextId = contextId;
        }

        protected abstract void execute();

        public void run() {
            if (this.isRequestContextActive()) {
                this.execute();
            } else {
                RequestContext requestContext = (RequestContext)Container.instance((String)this.contextId).deploymentManager().instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
                try {
                    requestContext.activate();
                    this.execute();
                }
                finally {
                    requestContext.invalidate();
                    requestContext.deactivate();
                }
            }
        }

        private boolean isRequestContextActive() {
            return Container.instance((String)this.contextId).deploymentManager().isContextActive(RequestScoped.class);
        }
    }
}

