/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.LinkedHashSet;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.QueryProducer;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.core.QueryProducerImpl;
import org.infinispan.query.core.impl.EmbeddedQuery;
import org.infinispan.query.core.impl.ExternalizerIds;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.core.impl.QueryEngine;
import org.infinispan.query.core.impl.continuous.ContinuousQueryResult;
import org.infinispan.query.core.impl.continuous.IckleContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.core.impl.eventfilter.IckleCacheEventFilterConverter;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.impl.IndexStatisticsSnapshotImpl;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.core.stats.impl.PersistenceContextInitializerImpl;
import org.infinispan.query.core.stats.impl.SearchStatsRetriever;
import org.infinispan.registry.InternalCacheRegistry;

@InfinispanModule(name="query-core", requiredModules={"core"})
public class LifecycleManager
implements ModuleLifecycle {
    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName) || icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.QUERYABLE)) {
            cr.registerComponent((Object)new IndexStatisticsSnapshotImpl(), IndexStatistics.class);
            cr.registerComponent((Object)new LocalQueryStatistics(), LocalQueryStatistics.class);
            cr.registerComponent((Object)new SearchStatsRetriever(), SearchStatsRetriever.class);
            AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
            ClassLoader aggregatedClassLoader = this.makeAggregatedClassLoader(cr.getGlobalComponentRegistry().getGlobalConfiguration().classLoader());
            cr.registerComponent((Object)new ReflectionMatcher(aggregatedClassLoader), ReflectionMatcher.class);
            QueryEngine engine = new QueryEngine(cache);
            cr.registerComponent(engine, QueryEngine.class);
            cr.registerComponent((Object)new QueryProducerImpl(engine), QueryProducer.class);
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
    }

    private ClassLoader makeAggregatedClassLoader(ClassLoader globalClassLoader) {
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>(6);
        if (globalClassLoader != null) {
            classLoaders.add(globalClassLoader);
        }
        classLoaders.add(AggregatedClassLoader.class.getClassLoader());
        classLoaders.add(this.getClass().getClassLoader());
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                classLoaders.add(tccl);
            }
        }
        catch (Exception tccl) {
            // empty catch block
        }
        try {
            ClassLoader syscl = ClassLoader.getSystemClassLoader();
            if (syscl != null) {
                classLoaders.add(syscl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AggregatedClassLoader(classLoaders);
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        gcr.registerComponent((Object)new QueryCache(), QueryCache.class);
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_AND_CONVERTER, new IckleFilterAndConverter.IckleFilterAndConverterExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_RESULT, new IckleFilterAndConverter.FilterResultExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CACHE_EVENT_FILTER_CONVERTER, new IckleCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new IckleContinuousQueryCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT, new ContinuousQueryResult.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_DELETE_FUNCTION, new EmbeddedQuery.DeleteFunctionExternalizer());
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
    }

    public void cacheManagerStopped(GlobalComponentRegistry gcr) {
    }
}

