/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.Interceptors;

final class ManagedReferenceLifecycleMethodInterceptor
implements Interceptor {
    private final Object contextKey;
    private final Method method;
    private final boolean changeMethod;
    private final boolean lifecycleMethod;
    private final boolean withContext;

    ManagedReferenceLifecycleMethodInterceptor(Object contextKey, Method method, boolean changeMethod) {
        this(contextKey, method, changeMethod, false);
    }

    ManagedReferenceLifecycleMethodInterceptor(Object contextKey, Method method, boolean changeMethod, boolean lifecycleMethod) {
        this.contextKey = contextKey;
        this.method = method;
        this.changeMethod = changeMethod;
        this.lifecycleMethod = lifecycleMethod;
        this.withContext = method.getParameterCount() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        ManagedReference reference = (ManagedReference)((ComponentInstance)context.getPrivateData(ComponentInstance.class)).getInstanceData(this.contextKey);
        Object instance = reference.getInstance();
        try {
            Method method = this.method;
            if (!this.withContext) {
                method.invoke(instance, new Object[0]);
                return context.proceed();
            }
            Method oldMethod = context.getMethod();
            try {
                if (this.lifecycleMethod) {
                    context.setMethod(null);
                    Object object = method.invoke(instance, context.getInvocationContext());
                    return object;
                }
                if (this.changeMethod) {
                    context.setMethod(method);
                    Object object = method.invoke(instance, context.getInvocationContext());
                    return object;
                }
                Object object = method.invoke(instance, context.getInvocationContext());
                return object;
            }
            finally {
                context.setMethod(oldMethod);
            }
        }
        catch (IllegalAccessException e) {
            IllegalAccessError n = new IllegalAccessError(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
    }
}

