/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ee.concurrent.ConcurrencyImplementation;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.DefaultBindingsResourceDefinition;
import org.jboss.as.ee.subsystem.EESubsystemModel;
import org.jboss.as.ee.subsystem.EeExtension;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EESubsystemParser40
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    EESubsystemParser40() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress subsystemPathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{EeExtension.PATH_SUBSYSTEM});
        ModelNode eeSubSystem = Util.createAddOperation((PathAddress)subsystemPathAddress);
        list.add(eeSubSystem);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case EE_4_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.readElement(reader, list, subsystemPathAddress, eeSubSystem);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void readElement(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress subsystemPathAddress, ModelNode eeSubSystem) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case GLOBAL_MODULES: {
                ModelNode model = EESubsystemParser40.parseGlobalModules(reader);
                eeSubSystem.get("global-modules").set(model);
                break;
            }
            case EAR_SUBDEPLOYMENTS_ISOLATED: {
                String earSubDeploymentsIsolated = EESubsystemParser40.parseEarSubDeploymentsIsolatedElement(reader);
                EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.parseAndSetParameter(earSubDeploymentsIsolated, eeSubSystem, (XMLStreamReader)reader);
                break;
            }
            case SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT: {
                String enabled = EESubsystemParser40.parseSpecDescriptorPropertyReplacement(reader);
                EeSubsystemRootResource.SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT.parseAndSetParameter(enabled, eeSubSystem, (XMLStreamReader)reader);
                break;
            }
            case JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT: {
                String enabled = EESubsystemParser40.parseJBossDescriptorPropertyReplacement(reader);
                EeSubsystemRootResource.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT.parseAndSetParameter(enabled, eeSubSystem, (XMLStreamReader)reader);
                break;
            }
            case ANNOTATION_PROPERTY_REPLACEMENT: {
                String enabled = EESubsystemParser40.parseEJBAnnotationPropertyReplacement(reader);
                EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT.parseAndSetParameter(enabled, eeSubSystem, (XMLStreamReader)reader);
                break;
            }
            case CONCURRENT: {
                ConcurrencyImplementation.INSTANCE.parseConcurrentElement40(reader, list, subsystemPathAddress);
                break;
            }
            case DEFAULT_BINDINGS: {
                EESubsystemParser40.parseDefaultBindings(reader, list, subsystemPathAddress);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    static ModelNode parseGlobalModules(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode globalModules = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case MODULE: {
                    ModelNode module = new ModelNode();
                    int count = reader.getAttributeCount();
                    String name = null;
                    String slot = null;
                    String annotations = null;
                    String metaInf = null;
                    String services = null;
                    block11: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                if (name != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                name = value;
                                GlobalModulesDefinition.NAME_AD.parseAndSetParameter(name, module, (XMLStreamReader)reader);
                                continue block11;
                            }
                            case SLOT: {
                                if (slot != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                slot = value;
                                GlobalModulesDefinition.SLOT_AD.parseAndSetParameter(slot, module, (XMLStreamReader)reader);
                                continue block11;
                            }
                            case ANNOTATIONS: {
                                if (annotations != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                annotations = value;
                                GlobalModulesDefinition.ANNOTATIONS_AD.parseAndSetParameter(annotations, module, (XMLStreamReader)reader);
                                continue block11;
                            }
                            case SERVICES: {
                                if (services != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                services = value;
                                GlobalModulesDefinition.SERVICES_AD.parseAndSetParameter(services, module, (XMLStreamReader)reader);
                                continue block11;
                            }
                            case META_INF: {
                                if (metaInf != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                metaInf = value;
                                GlobalModulesDefinition.META_INF_AD.parseAndSetParameter(metaInf, module, (XMLStreamReader)reader);
                                continue block11;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (name == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
                    }
                    globalModules.add(module);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return globalModules;
    }

    static String parseEarSubDeploymentsIsolatedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String value = reader.getElementText();
        if (value == null || value.trim().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.invalidValue(value, Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName(), reader.getLocation());
        }
        return value.trim();
    }

    static String parseSpecDescriptorPropertyReplacement(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String value = reader.getElementText();
        if (value == null || value.trim().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.invalidValue(value, Element.SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT.getLocalName(), reader.getLocation());
        }
        return value.trim();
    }

    static String parseJBossDescriptorPropertyReplacement(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String value = reader.getElementText();
        if (value == null || value.trim().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.invalidValue(value, Element.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT.getLocalName(), reader.getLocation());
        }
        return value.trim();
    }

    static String parseEJBAnnotationPropertyReplacement(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String value = reader.getElementText();
        return value.trim();
    }

    static void parseDefaultBindings(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPathAddress) throws XMLStreamException {
        ModelNode addOperation = Util.createAddOperation();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONTEXT_SERVICE: {
                    DefaultBindingsResourceDefinition.CONTEXT_SERVICE_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case DATASOURCE: {
                    DefaultBindingsResourceDefinition.DATASOURCE_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case JMS_CONNECTION_FACTORY: {
                    DefaultBindingsResourceDefinition.JMS_CONNECTION_FACTORY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case MANAGED_EXECUTOR_SERVICE: {
                    DefaultBindingsResourceDefinition.MANAGED_EXECUTOR_SERVICE_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case MANAGED_SCHEDULED_EXECUTOR_SERVICE: {
                    DefaultBindingsResourceDefinition.MANAGED_SCHEDULED_EXECUTOR_SERVICE_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case MANAGED_THREAD_FACTORY: {
                    DefaultBindingsResourceDefinition.MANAGED_THREAD_FACTORY_AD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = subsystemPathAddress.append(new PathElement[]{EESubsystemModel.DEFAULT_BINDINGS_PATH});
        addOperation.get("address").set(address.toModelNode());
        operations.add(addOperation);
    }
}

