/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.apiimpl.AsyncInvocation;
import io.smallrye.faulttolerance.core.apiimpl.CallableInvoker;
import io.smallrye.faulttolerance.core.apiimpl.EventHandlers;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.AsyncSupportRegistry;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.StrategyInvoker;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

final class GuardCommon {
    private static final Class<?>[] NO_PARAMS = new Class[0];

    GuardCommon() {
    }

    static <V, T> AsyncSupport<V, T> asyncSupport(Type type) {
        if (type instanceof Class) {
            return AsyncSupportRegistry.get(NO_PARAMS, (Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            return AsyncSupportRegistry.get(NO_PARAMS, rawType);
        }
        return null;
    }

    static <V, T> AsyncInvocation<V, T> asyncInvocation(Callable<T> action, AsyncSupport<V, T> asyncSupport) {
        return asyncSupport != null ? new AsyncInvocation<V, T>(asyncSupport, new CallableInvoker<T>(action), null) : null;
    }

    static <V, T> T guard(Callable<T> action, FaultToleranceStrategy<V> strategy, AsyncInvocation<V, T> asyncInvocation, EventHandlers eventHandlers, Consumer<FaultToleranceContext<?>> contextModifier) throws Exception {
        if (asyncInvocation == null) {
            FaultToleranceContext ctx = new FaultToleranceContext(() -> Future.from(action), false);
            if (contextModifier != null) {
                contextModifier.accept(ctx);
            }
            eventHandlers.register(ctx);
            try {
                FaultToleranceStrategy castStrategy = strategy;
                return (T)castStrategy.apply(ctx).awaitBlocking();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                throw SneakyThrow.sneakyThrow(e);
            }
        }
        AsyncSupport asyncSupport = asyncInvocation.asyncSupport;
        Invoker toFutureInvoker = asyncInvocation.toFutureInvoker;
        FaultToleranceContext ctx = new FaultToleranceContext(() -> asyncSupport.toFuture(toFutureInvoker), true);
        if (contextModifier != null) {
            contextModifier.accept(ctx);
        }
        eventHandlers.register(ctx);
        StrategyInvoker<V> fromFutureInvoker = new StrategyInvoker<V>(asyncInvocation.arguments, strategy, ctx);
        return (T)asyncSupport.fromFuture(fromFutureInvoker);
    }
}

