/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config.amqp.ssl.context._private;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.smallrye.reactive.messaging.ClientCustomizer;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.spi.tls.SslContextFactory;
import jakarta.enterprise.context.ApplicationScoped;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.config.Config;
import org.wildfly.microprofile.reactive.messaging.common.security.ElytronSSLContextRegistry;

@ApplicationScoped
public class AmqpClientCustomizer
implements ClientCustomizer<AmqpClientOptions> {
    public AmqpClientOptions customize(String channel, Config channelConfig, AmqpClientOptions config) {
        String sslContextName = channelConfig.getOptionalValue("wildfly.elytron.ssl.context", String.class).orElse(null);
        if (sslContextName != null) {
            final SSLContext context = ElytronSSLContextRegistry.getInstalledSSLContext((String)sslContextName);
            config.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions(){

                public SslContextFactory sslContextFactory() {
                    return new SslContextFactory(){

                        public SslContext create() {
                            return new JdkSslContext(context, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, null, false);
                        }
                    };
                }
            });
        }
        return config;
    }
}

