/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.api;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.api.SpiAccess;
import jakarta.enterprise.util.TypeLiteral;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Experimental(value="second attempt at providing programmatic API")
public interface TypedGuard<T> {
    public static <T> Builder<T> create(Class<T> type) {
        return SpiAccess.get().newTypedGuardBuilder(type);
    }

    public static <T> Builder<T> create(TypeLiteral<T> type) {
        return SpiAccess.get().newTypedGuardBuilder(type.getType());
    }

    public T call(Callable<T> var1) throws Exception;

    public T get(Supplier<T> var1);

    default public Callable<T> adaptCallable(Callable<T> action) {
        return () -> this.call(action);
    }

    default public Supplier<T> adaptSupplier(Supplier<T> action) {
        return () -> this.get(action);
    }

    public static interface Builder<T> {
        public Builder<T> withDescription(String var1);

        public BulkheadBuilder<T> withBulkhead();

        public CircuitBreakerBuilder<T> withCircuitBreaker();

        public FallbackBuilder<T> withFallback();

        public RateLimitBuilder<T> withRateLimit();

        public RetryBuilder<T> withRetry();

        public TimeoutBuilder<T> withTimeout();

        public Builder<T> withThreadOffload(boolean var1);

        public Builder<T> withThreadOffloadExecutor(Executor var1);

        public TypedGuard<T> build();

        default public Builder<T> with(Consumer<Builder<T>> consumer) {
            consumer.accept(this);
            return this;
        }

        public static interface TimeoutBuilder<T> {
            public TimeoutBuilder<T> duration(long var1, ChronoUnit var3);

            public TimeoutBuilder<T> onTimeout(Runnable var1);

            public TimeoutBuilder<T> onFinished(Runnable var1);

            public Builder<T> done();

            default public TimeoutBuilder<T> with(Consumer<TimeoutBuilder<T>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface RetryBuilder<T> {
            public RetryBuilder<T> maxRetries(int var1);

            public RetryBuilder<T> delay(long var1, ChronoUnit var3);

            public RetryBuilder<T> maxDuration(long var1, ChronoUnit var3);

            public RetryBuilder<T> jitter(long var1, ChronoUnit var3);

            public RetryBuilder<T> retryOn(Collection<Class<? extends Throwable>> var1);

            default public RetryBuilder<T> retryOn(Class<? extends Throwable> value) {
                return this.retryOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public RetryBuilder<T> abortOn(Collection<Class<? extends Throwable>> var1);

            default public RetryBuilder<T> abortOn(Class<? extends Throwable> value) {
                return this.abortOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public RetryBuilder<T> whenResult(Predicate<Object> var1);

            public RetryBuilder<T> whenException(Predicate<Throwable> var1);

            public RetryBuilder<T> beforeRetry(Runnable var1);

            public RetryBuilder<T> beforeRetry(Consumer<Throwable> var1);

            public ExponentialBackoffBuilder<T> withExponentialBackoff();

            public FibonacciBackoffBuilder<T> withFibonacciBackoff();

            public CustomBackoffBuilder<T> withCustomBackoff();

            public RetryBuilder<T> onRetry(Runnable var1);

            public RetryBuilder<T> onSuccess(Runnable var1);

            public RetryBuilder<T> onFailure(Runnable var1);

            public Builder<T> done();

            default public RetryBuilder<T> with(Consumer<RetryBuilder<T>> consumer) {
                consumer.accept(this);
                return this;
            }

            public static interface CustomBackoffBuilder<T> {
                public CustomBackoffBuilder<T> strategy(Supplier<CustomBackoffStrategy> var1);

                public RetryBuilder<T> done();

                default public CustomBackoffBuilder<T> with(Consumer<CustomBackoffBuilder<T>> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }

            public static interface FibonacciBackoffBuilder<T> {
                public FibonacciBackoffBuilder<T> maxDelay(long var1, ChronoUnit var3);

                public RetryBuilder<T> done();

                default public FibonacciBackoffBuilder<T> with(Consumer<FibonacciBackoffBuilder<T>> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }

            public static interface ExponentialBackoffBuilder<T> {
                public ExponentialBackoffBuilder<T> factor(int var1);

                public ExponentialBackoffBuilder<T> maxDelay(long var1, ChronoUnit var3);

                public RetryBuilder<T> done();

                default public ExponentialBackoffBuilder<T> with(Consumer<ExponentialBackoffBuilder<T>> consumer) {
                    consumer.accept(this);
                    return this;
                }
            }
        }

        public static interface RateLimitBuilder<T> {
            public RateLimitBuilder<T> limit(int var1);

            public RateLimitBuilder<T> window(long var1, ChronoUnit var3);

            public RateLimitBuilder<T> minSpacing(long var1, ChronoUnit var3);

            public RateLimitBuilder<T> type(RateLimitType var1);

            public RateLimitBuilder<T> onPermitted(Runnable var1);

            public RateLimitBuilder<T> onRejected(Runnable var1);

            public Builder<T> done();

            default public RateLimitBuilder<T> with(Consumer<RateLimitBuilder<T>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface FallbackBuilder<T> {
            public FallbackBuilder<T> handler(Supplier<T> var1);

            public FallbackBuilder<T> handler(Function<Throwable, T> var1);

            public FallbackBuilder<T> applyOn(Collection<Class<? extends Throwable>> var1);

            default public FallbackBuilder<T> applyOn(Class<? extends Throwable> value) {
                return this.applyOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public FallbackBuilder<T> skipOn(Collection<Class<? extends Throwable>> var1);

            default public FallbackBuilder<T> skipOn(Class<? extends Throwable> value) {
                return this.skipOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public FallbackBuilder<T> when(Predicate<Throwable> var1);

            public Builder<T> done();

            default public FallbackBuilder<T> with(Consumer<FallbackBuilder<T>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface CircuitBreakerBuilder<T> {
            public CircuitBreakerBuilder<T> failOn(Collection<Class<? extends Throwable>> var1);

            default public CircuitBreakerBuilder<T> failOn(Class<? extends Throwable> value) {
                return this.failOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public CircuitBreakerBuilder<T> skipOn(Collection<Class<? extends Throwable>> var1);

            default public CircuitBreakerBuilder<T> skipOn(Class<? extends Throwable> value) {
                return this.skipOn(Collections.singleton(Objects.requireNonNull(value)));
            }

            public CircuitBreakerBuilder<T> when(Predicate<Throwable> var1);

            public CircuitBreakerBuilder<T> delay(long var1, ChronoUnit var3);

            public CircuitBreakerBuilder<T> requestVolumeThreshold(int var1);

            public CircuitBreakerBuilder<T> failureRatio(double var1);

            public CircuitBreakerBuilder<T> successThreshold(int var1);

            public CircuitBreakerBuilder<T> name(String var1);

            public CircuitBreakerBuilder<T> onStateChange(Consumer<CircuitBreakerState> var1);

            public CircuitBreakerBuilder<T> onSuccess(Runnable var1);

            public CircuitBreakerBuilder<T> onFailure(Runnable var1);

            public CircuitBreakerBuilder<T> onPrevented(Runnable var1);

            public Builder<T> done();

            default public CircuitBreakerBuilder<T> with(Consumer<CircuitBreakerBuilder<T>> consumer) {
                consumer.accept(this);
                return this;
            }
        }

        public static interface BulkheadBuilder<T> {
            public BulkheadBuilder<T> limit(int var1);

            public BulkheadBuilder<T> queueSize(int var1);

            public BulkheadBuilder<T> enableSynchronousQueueing();

            public BulkheadBuilder<T> onAccepted(Runnable var1);

            public BulkheadBuilder<T> onRejected(Runnable var1);

            public BulkheadBuilder<T> onFinished(Runnable var1);

            public Builder<T> done();

            default public BulkheadBuilder<T> with(Consumer<BulkheadBuilder<T>> consumer) {
                consumer.accept(this);
                return this;
            }
        }
    }
}

