/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Predicate;

public class MultiOnFailureSpy<T>
extends MultiSpyBase<T> {
    private Predicate<? super Throwable> predicate;
    private Class<? extends Throwable> typeOfFailure;
    private volatile Throwable lastFailure;

    public Throwable lastFailure() {
        return this.lastFailure;
    }

    MultiOnFailureSpy(Multi<? extends T> upstream) {
        super(upstream);
    }

    MultiOnFailureSpy(Multi<? extends T> upstream, Predicate<? super Throwable> predicate) {
        super(upstream);
        this.predicate = predicate;
    }

    MultiOnFailureSpy(Multi<? extends T> upstream, Class<? extends Throwable> typeOfFailure) {
        super(upstream);
        this.typeOfFailure = typeOfFailure;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastFailure = null;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> dowstream) {
        MultiOnFailure group = this.predicate != null ? this.upstream.onFailure(this.predicate) : (this.typeOfFailure != null ? this.upstream.onFailure(this.typeOfFailure) : this.upstream.onFailure());
        group.invoke((Throwable failure) -> {
            this.incrementInvocationCount();
            this.lastFailure = failure;
        }).subscribe().withSubscriber(dowstream);
    }

    @Override
    public String toString() {
        return "MultiOnFailureSpy{lastFailure=" + this.lastFailure + "} " + super.toString();
    }
}

