/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import org.wildfly.clustering.session.cache.user.CompositeUser;
import org.wildfly.clustering.session.cache.user.UserContextFactory;
import org.wildfly.clustering.session.cache.user.UserFactory;
import org.wildfly.clustering.session.cache.user.UserSessionsFactory;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserSessions;

public class CompositeUserFactory<CV, C, T, SV, D, S>
implements UserFactory<CV, C, T, SV, D, S> {
    private final UserContextFactory<CV, C, T> contextFactory;
    private final UserSessionsFactory<SV, D, S> sessionsFactory;

    public CompositeUserFactory(UserContextFactory<CV, C, T> contextFactory, UserSessionsFactory<SV, D, S> sessionsFactory) {
        this.contextFactory = contextFactory;
        this.sessionsFactory = sessionsFactory;
    }

    @Override
    public User<C, T, D, S> createUser(String id, Map.Entry<CV, SV> entry) {
        CV contextValue = entry.getKey();
        SV sessionsValue = entry.getValue();
        if (contextValue == null || sessionsValue == null) {
            return null;
        }
        Map.Entry<C, T> context = this.contextFactory.createUserContext(contextValue);
        UserSessions<D, S> sessions = this.sessionsFactory.createUserSessions(id, sessionsValue);
        return new CompositeUser<C, T, D, S>(id, context, sessions, this);
    }

    @Override
    public UserContextFactory<CV, C, T> getUserContextFactory() {
        return this.contextFactory;
    }

    @Override
    public UserSessionsFactory<SV, D, S> getUserSessionsFactory() {
        return this.sessionsFactory;
    }
}

