/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.reporting.FailureContext;

public class EntityIndexingFailureContext
extends FailureContext {
    private final List<EntityReference> failingEntityReferences;

    public static Builder builder() {
        return new Builder();
    }

    private EntityIndexingFailureContext(Builder builder) {
        super(builder);
        this.failingEntityReferences = builder.failingEntityReferences == null ? Collections.emptyList() : Collections.unmodifiableList(builder.failingEntityReferences);
    }

    @Deprecated
    public List<Object> entityReferences() {
        return this.failingEntityReferences;
    }

    public List<EntityReference> failingEntityReferences() {
        return this.failingEntityReferences;
    }

    @Override
    public String toString() {
        return "EntityIndexingFailureContext{failingEntityReferences=" + String.valueOf(this.failingEntityReferences) + ", throwable=" + String.valueOf(this.throwable) + ", failingOperation=" + String.valueOf(this.failingOperation) + "}";
    }

    public static class Builder
    extends FailureContext.Builder {
        private List<EntityReference> failingEntityReferences;

        private Builder() {
        }

        @Deprecated
        public void entityReference(Object entityReference) {
            this.failingEntityReference((EntityReference)entityReference);
        }

        public void failingEntityReference(EntityReference entityReference) {
            if (this.failingEntityReferences == null) {
                this.failingEntityReferences = new ArrayList<EntityReference>();
            }
            this.failingEntityReferences.add(entityReference);
        }

        @Override
        public EntityIndexingFailureContext build() {
            return new EntityIndexingFailureContext(this);
        }
    }
}

