/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Instant;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.function.Functions;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheEntryComputerFactory;
import org.wildfly.clustering.ejb.bean.BeanExpiration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanMetaData;
import org.wildfly.clustering.ejb.bean.ImmutableBeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataEntryFunction;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataFactory;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataKey;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.DefaultImmutableBeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.MutableBeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.RemappableBeanMetaDataEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataFactoryConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataKey;
import org.wildfly.clustering.server.offset.OffsetValue;

public class InfinispanBeanMetaDataFactory<K>
implements BeanMetaDataFactory<K, RemappableBeanMetaDataEntry<K>> {
    private final Cache<BeanMetaDataKey<K>, RemappableBeanMetaDataEntry<K>> writeOnlyCache;
    private final Cache<BeanMetaDataKey<K>, RemappableBeanMetaDataEntry<K>> readForUpdateCache;
    private final Cache<BeanMetaDataKey<K>, RemappableBeanMetaDataEntry<K>> tryReadForUpdateCache;
    private final CacheEntryMutatorFactory<BeanMetaDataKey<K>, OffsetValue<Instant>> mutatorFactory;
    private final BeanExpiration expiration;
    private final String beanName;

    public InfinispanBeanMetaDataFactory(InfinispanBeanMetaDataFactoryConfiguration configuration) {
        this.writeOnlyCache = configuration.getWriteOnlyCache();
        this.readForUpdateCache = configuration.getReadForUpdateCache();
        this.tryReadForUpdateCache = configuration.getTryReadForUpdateCache();
        this.expiration = configuration.getExpiration();
        this.mutatorFactory = this.expiration != null && !this.expiration.getTimeout().isZero() ? new EmbeddedCacheEntryComputerFactory(this.writeOnlyCache, BeanMetaDataEntryFunction::new) : null;
        this.beanName = configuration.getBeanName();
    }

    public CompletionStage<RemappableBeanMetaDataEntry<K>> createValueAsync(BeanInstance<K> instance, K groupId) {
        DefaultBeanMetaDataEntry entry = new DefaultBeanMetaDataEntry(this.beanName, groupId);
        return this.writeOnlyCache.putAsync(new InfinispanBeanMetaDataKey<Object>(instance.getId()), (Object)entry).thenApply(Functions.constantFunction((Object)entry));
    }

    public CompletionStage<RemappableBeanMetaDataEntry<K>> findValueAsync(K id) {
        return this.readForUpdateCache.getAsync(new InfinispanBeanMetaDataKey<K>(id));
    }

    public CompletionStage<RemappableBeanMetaDataEntry<K>> tryValueAsync(K id) {
        return this.tryReadForUpdateCache.getAsync(new InfinispanBeanMetaDataKey<K>(id));
    }

    public CompletionStage<Void> removeAsync(K id) {
        return this.writeOnlyCache.removeAsync(new InfinispanBeanMetaDataKey<K>(id)).thenAccept(org.wildfly.common.function.Functions.discardingConsumer());
    }

    public void remove(K id) {
        this.writeOnlyCache.remove(new InfinispanBeanMetaDataKey<K>(id));
    }

    public ImmutableBeanMetaData<K> createImmutableBeanMetaData(K id, RemappableBeanMetaDataEntry<K> entry) {
        return new DefaultImmutableBeanMetaData(entry, this.expiration);
    }

    public BeanMetaData<K> createBeanMetaData(K id, RemappableBeanMetaDataEntry<K> entry) {
        OffsetValue lastAccess = this.mutatorFactory != null ? entry.getLastAccess().rebase() : entry.getLastAccess();
        CacheEntryMutator mutator = this.mutatorFactory != null ? this.mutatorFactory.createMutator(new InfinispanBeanMetaDataKey<K>(id), (Object)lastAccess) : CacheEntryMutator.NO_OP;
        return new DefaultBeanMetaData((BeanMetaDataEntry)(this.mutatorFactory != null ? new MutableBeanMetaDataEntry((ImmutableBeanMetaDataEntry)entry, lastAccess) : entry), this.expiration, mutator);
    }
}

