/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.impl.ClientConfigurationImpl;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.SecurityFactory;

public interface ModelControllerClientConfiguration
extends Closeable {
    public String getHost();

    public int getPort();

    public String getProtocol();

    public int getConnectionTimeout();

    public CallbackHandler getCallbackHandler();

    public Map<String, String> getSaslOptions();

    @Deprecated(forRemoval=true)
    public SSLContext getSSLContext();

    public SecurityFactory<SSLContext> getSslContextFactory();

    public ExecutorService getExecutor();

    public String getClientBindAddress();

    @Deprecated
    default public URI getAuthenticationConfigUri() {
        return null;
    }

    public static class Builder {
        private static final ThreadGroup defaultThreadGroup = new ThreadGroup("management-client-thread");
        private static final AtomicInteger executorCount = new AtomicInteger();
        private static final String MAX_THREADS_PROP = "org.jboss.as.controller.client.max-threads";
        private static final int MAX_THREADS_DEFAULT = 6;
        private String hostName;
        private String clientBindAddress;
        private int port;
        private CallbackHandler handler;
        private Map<String, String> saslOptions;
        private SecurityFactory<SSLContext> sslContextFactory;
        private String protocol;
        private int connectionTimeout = 0;
        private URI authConfigUri;

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder setClientBindAddress(String clientBindAddress) {
            this.clientBindAddress = clientBindAddress;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setHandler(CallbackHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder setSaslOptions(Map<String, String> saslOptions) {
            this.saslOptions = saslOptions;
            return this;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContextFactory = () -> sslContext;
            return this;
        }

        public Builder setSslContextFactory(SecurityFactory<SSLContext> sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Deprecated
        public Builder setAuthenticationConfigUri(URI authConfigUri) {
            this.authConfigUri = authConfigUri;
            return this;
        }

        public ModelControllerClientConfiguration build() {
            return new ClientConfigurationImpl(this.hostName, this.port, this.handler, this.saslOptions, this.sslContextFactory, Builder.createDefaultExecutor(), true, this.connectionTimeout, this.protocol, this.clientBindAddress, this.authConfigUri);
        }

        private static ExecutorService createDefaultExecutor() {
            ThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

                @Override
                public JBossThreadFactory run() {
                    return new JBossThreadFactory(defaultThreadGroup, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null);
                }
            });
            int maxThreads = Builder.getMaxThreads();
            return EnhancedQueueExecutor.DISABLE_HINT ? new ThreadPoolExecutor(2, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), threadFactory) : new EnhancedQueueExecutor.Builder().setCorePoolSize(2).setMaximumPoolSize(maxThreads).setKeepAliveTime(60L, TimeUnit.SECONDS).setThreadFactory(threadFactory).build();
        }

        private static int getMaxThreads() {
            String value = Builder.getMaxThreadsProperty();
            try {
                return value == null ? 6 : Integer.parseInt(value);
            }
            catch (NumberFormatException ignored) {
                return 6;
            }
        }

        private static String getMaxThreadsProperty() {
            return System.getSecurityManager() == null ? System.getProperty(MAX_THREADS_PROP) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(Builder.MAX_THREADS_PROP);
                }
            });
        }
    }
}

