/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.servlet.api.SessionConfigWrapper;
import io.undertow.servlet.api.SessionManagerFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.web.session.AffinityLocator;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.as.web.session.SimpleAffinityLocator;
import org.jboss.as.web.session.SimpleSessionIdentifierCodec;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.web.container.SessionManagementProvider;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.undertow.CookieConfig;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.session.AffinitySessionConfigWrapper;
import org.wildfly.extension.undertow.session.CodecSessionConfigWrapper;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class NonDistributableSessionManagementProvider
implements SessionManagementProvider {
    private final Function<SessionManagerFactoryConfiguration, SessionManagerFactory> factory;

    public NonDistributableSessionManagementProvider(Function<SessionManagerFactoryConfiguration, SessionManagerFactory> factory) {
        this.factory = factory;
    }

    public DeploymentServiceInstaller getSessionManagerFactoryServiceInstaller(ServiceName name, SessionManagerFactoryConfiguration configuration) {
        Supplier<SessionManagerFactory> provider = () -> this.factory.apply(configuration);
        return (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(provider).provides(name)).build();
    }

    public DeploymentServiceInstaller getSessionAffinityServiceInstaller(DeploymentPhaseContext context, ServiceName name, WebDeploymentConfiguration configuration) {
        final ServiceDependency server = ServiceDependency.on(Server.SERVICE_DESCRIPTOR, (String)configuration.getServerName());
        Function<CookieConfig, SessionConfigWrapper> wrapperFactory = new Function<CookieConfig, SessionConfigWrapper>(){

            @Override
            public SessionConfigWrapper apply(CookieConfig config) {
                String route = ((Server)server.get()).getRoute();
                SimpleSessionIdentifierCodec codec = new SimpleSessionIdentifierCodec(route);
                return config != null ? new AffinitySessionConfigWrapper(config, (AffinityLocator)new SimpleAffinityLocator(route)) : new CodecSessionConfigWrapper((SessionIdentifierCodec)codec);
            }
        };
        return (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)Functions.constantSupplier((Object)wrapperFactory)).provides(name)).requires((Consumer)server)).build();
    }
}

