/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.executors.ScheduledExecutorFactory;

public class DefaultScheduledExecutorFactory
implements ScheduledExecutorFactory {
    static final AtomicInteger counter = new AtomicInteger(0);

    @Override
    public ScheduledExecutorService getScheduledExecutor(Properties p) {
        TypedProperties tp = new TypedProperties((Map)p);
        final String threadNamePrefix = p.getProperty("threadNamePrefix", p.getProperty("componentName", "Thread"));
        final int threadPrio = tp.getIntProperty("threadPriority", 1);
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread createThread(Runnable r) {
                Thread th = new Thread(r, "Scheduled-" + threadNamePrefix + "-" + counter.getAndIncrement());
                th.setDaemon(true);
                th.setPriority(threadPrio);
                return th;
            }

            @Override
            public Thread newThread(Runnable r) {
                Runnable runnable = r;
                return this.createThread(runnable);
            }
        });
    }
}

