/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters.logs;

import io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.smallrye.opentelemetry.implementation.exporters.AbstractVertxExporterProvider;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.smallrye.opentelemetry.implementation.exporters.logs.VertxGrpcLogsExporter;
import io.smallrye.opentelemetry.implementation.exporters.logs.VertxHttpLogsExporter;
import java.net.URISyntaxException;

public class VertxLogsExporterProvider
extends AbstractVertxExporterProvider<LogsRequestMarshaler>
implements ConfigurableLogRecordExporterProvider {
    public VertxLogsExporterProvider() {
        super("logs", "otlp");
    }

    public LogRecordExporter createExporter(ConfigProperties config) {
        try {
            String protocol = OtlpExporterUtil.getProtocol(config, this.getSignalType());
            if ("grpc".equals(protocol)) {
                return new VertxGrpcLogsExporter(this.createGrpcExporter(config, "opentelemetry.proto.collector.trace.v1.TraceService"));
            }
            if ("http/protobuf".equals(protocol)) {
                return new VertxHttpLogsExporter(this.createHttpExporter(config, "/v1/logs"));
            }
            throw this.buildUnsupportedProtocolException(protocol);
        }
        catch (IllegalArgumentException | URISyntaxException iae) {
            throw new IllegalStateException("Unable to install OTLP Exporter", iae);
        }
    }
}

