/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters.sender;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.smallrye.mutiny.Uni;
import io.smallrye.opentelemetry.implementation.exporters.BufferOutputStream;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VertxGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    public static final String GRPC_TRACE_SERVICE_NAME = "opentelemetry.proto.collector.trace.v1.TraceService";
    public static final String GRPC_METRIC_SERVICE_NAME = "opentelemetry.proto.collector.metrics.v1.MetricsService";
    private static final String GRPC_METHOD_NAME = "Export";
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private static final Logger internalLogger = Logger.getLogger(VertxGrpcSender.class.getName());
    private static final int MAX_ATTEMPTS = 3;
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final CompletableResultCode shutdownResult = new CompletableResultCode();
    private final SocketAddress server;
    private final boolean compressionEnabled;
    private final Map<String, String> headers;
    private final String signalType;
    private final String grpcEndpointPath;
    private final GrpcClient client;

    public VertxGrpcSender(String signalType, URI grpcBaseUri, String grpcEndpointPath, boolean compressionEnabled, Duration timeout, Map<String, String> headersMap, Consumer<HttpClientOptions> clientOptionsCustomizer, Vertx vertx) {
        this.signalType = signalType;
        this.grpcEndpointPath = grpcEndpointPath;
        this.server = SocketAddress.inetSocketAddress((int)OtlpExporterUtil.getPort(grpcBaseUri), (String)grpcBaseUri.getHost());
        this.compressionEnabled = compressionEnabled;
        this.headers = headersMap;
        HttpClientOptions httpClientOptions = new HttpClientOptions().setHttp2ClearTextUpgrade(false).setReadIdleTimeout((int)timeout.getSeconds()).setTracingPolicy(TracingPolicy.IGNORE);
        clientOptionsCustomizer.accept(httpClientOptions);
        this.client = GrpcClient.client((Vertx)vertx, (HttpClientOptions)httpClientOptions);
    }

    public void send(T marshaler, Consumer<GrpcResponse> onSuccess, final Consumer<Throwable> onError) {
        if (this.isShutdown.get()) {
            return;
        }
        final String marshalerType = marshaler.getClass().getSimpleName();
        ClientRequestOnSuccessHandler onSuccessHandler = new ClientRequestOnSuccessHandler(this.client, this.server, this.headers, this.compressionEnabled, (Marshaler)marshaler, this.loggedUnimplemented, this.logger, marshalerType, onSuccess, onError, 1, this.grpcEndpointPath, this.isShutdown::get);
        this.initiateSend((Marshaler)marshaler, this.client, this.server, 3, onSuccessHandler, new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                VertxGrpcSender.this.failOnClientRequest(marshalerType, throwable, onError);
            }
        });
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.FINE, "Calling shutdown() multiple times.");
            return this.shutdownResult;
        }
        this.client.close().onSuccess((Handler)new Handler<Void>(){

            public void handle(Void event) {
                VertxGrpcSender.this.shutdownResult.succeed();
            }
        }).onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                VertxGrpcSender.this.shutdownResult.fail();
            }
        });
        return this.shutdownResult;
    }

    void initiateSend(Marshaler request, final GrpcClient client, final SocketAddress server, int numberOfAttempts, Handler<GrpcClientRequest<Buffer, Buffer>> onSuccessHandler, Consumer<Throwable> onFailureCallback) {
        Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<GrpcClientRequest<Buffer, Buffer>>>(){

            @Override
            public CompletionStage get() {
                return client.request(server).toCompletionStage();
            }
        }).onFailure((Predicate)new Predicate<Throwable>(){

            @Override
            public boolean test(Throwable t) {
                return t instanceof IllegalStateException || t instanceof RejectedExecutionException;
            }
        }).recoverWithUni((Supplier)new Supplier<Uni<? extends GrpcClientRequest<Buffer, Buffer>>>(){

            @Override
            public Uni<? extends GrpcClientRequest<Buffer, Buffer>> get() {
                return Uni.createFrom().nothing();
            }
        }).onFailure().retry().withBackOff(Duration.ofMillis(100L)).atMost((long)numberOfAttempts).subscribe().with(request1 -> onSuccessHandler.handle(request1), onFailureCallback);
    }

    private void failOnClientRequest(String type, Throwable t, Consumer<Throwable> onError) {
        String message = "Failed to export " + type + "s. The request could not be executed. Full error message: " + (t.getMessage() == null ? t.getClass().getName() : t.getMessage());
        this.logger.log(Level.WARNING, message);
        onError.accept(t);
    }

    private final class ClientRequestOnSuccessHandler
    implements Handler<GrpcClientRequest<Buffer, Buffer>> {
        private final GrpcClient client;
        private final SocketAddress server;
        private final Map<String, String> headers;
        private final boolean compressionEnabled;
        private final Marshaler marshaler;
        private final AtomicBoolean loggedUnimplemented;
        private final ThrottlingLogger logger;
        private final String type;
        private final Consumer<GrpcResponse> onSuccess;
        private final Consumer<Throwable> onError;
        private final String grpcEndpointPath;
        private final int attemptNumber;
        private final Supplier<Boolean> isShutdown;

        public ClientRequestOnSuccessHandler(GrpcClient client, SocketAddress server, Map<String, String> headers, boolean compressionEnabled, Marshaler marshaler, AtomicBoolean loggedUnimplemented, ThrottlingLogger logger, String type, Consumer<GrpcResponse> onSuccess, Consumer<Throwable> onError, int attemptNumber, String grpcEndpointPath, Supplier<Boolean> isShutdown) {
            this.client = client;
            this.server = server;
            this.grpcEndpointPath = grpcEndpointPath;
            this.headers = headers;
            this.compressionEnabled = compressionEnabled;
            this.marshaler = marshaler;
            this.loggedUnimplemented = loggedUnimplemented;
            this.logger = logger;
            this.type = type;
            this.onSuccess = onSuccess;
            this.onError = onError;
            this.attemptNumber = attemptNumber;
            this.isShutdown = isShutdown;
        }

        public void handle(GrpcClientRequest<Buffer, Buffer> request) {
            if (this.compressionEnabled) {
                request.encoding("gzip");
            }
            request.serviceName(ServiceName.create((String)this.grpcEndpointPath));
            request.methodName(VertxGrpcSender.GRPC_METHOD_NAME);
            if (!this.headers.isEmpty()) {
                MultiMap vertxHeaders = request.headers();
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    vertxHeaders.set(entry.getKey(), entry.getValue());
                }
            }
            try {
                int messageSize = this.marshaler.getBinarySerializedSize();
                Buffer buffer = Buffer.buffer((int)messageSize);
                BufferOutputStream os = new BufferOutputStream(buffer);
                this.marshaler.writeBinaryTo((OutputStream)os);
                request.send((Object)buffer).onSuccess((Handler)new Handler<GrpcClientResponse<Buffer, Buffer>>(){

                    public void handle(final GrpcClientResponse<Buffer, Buffer> response) {
                        response.exceptionHandler((Handler)new Handler<Throwable>(){

                            public void handle(Throwable t) {
                                if (ClientRequestOnSuccessHandler.this.attemptNumber <= 3 && !ClientRequestOnSuccessHandler.this.isShutdown.get().booleanValue()) {
                                    VertxGrpcSender.this.initiateSend(ClientRequestOnSuccessHandler.this.marshaler, ClientRequestOnSuccessHandler.this.client, ClientRequestOnSuccessHandler.this.server, 3 - ClientRequestOnSuccessHandler.this.attemptNumber, ClientRequestOnSuccessHandler.this.newAttempt(), new Consumer<Throwable>(){

                                        @Override
                                        public void accept(Throwable throwable) {
                                            ClientRequestOnSuccessHandler.this.failOnClientRequest(throwable, ClientRequestOnSuccessHandler.this.onError, ClientRequestOnSuccessHandler.this.attemptNumber);
                                        }
                                    });
                                } else {
                                    ClientRequestOnSuccessHandler.this.failOnClientRequest(t, ClientRequestOnSuccessHandler.this.onError, ClientRequestOnSuccessHandler.this.attemptNumber);
                                }
                            }
                        }).errorHandler((Handler)new Handler<GrpcError>(){

                            public void handle(GrpcError error) {
                                this.handleError(error.status, (GrpcClientResponse<Buffer, Buffer>)response);
                            }
                        }).endHandler((Handler)new Handler<Void>(){

                            public void handle(Void ignored) {
                                GrpcStatus status = this.getStatus(response);
                                if (status == GrpcStatus.OK) {
                                    ClientRequestOnSuccessHandler.this.onSuccess.accept(GrpcResponse.create((int)response.status().code, (String)response.statusMessage()));
                                } else {
                                    this.handleError(status, (GrpcClientResponse<Buffer, Buffer>)response);
                                }
                            }
                        });
                    }

                    private void handleError(GrpcStatus status, GrpcClientResponse<Buffer, Buffer> response) {
                        String statusMessage = this.getStatusMessage(response);
                        this.logAppropriateWarning(status, statusMessage);
                        ClientRequestOnSuccessHandler.this.onError.accept(new IllegalStateException(statusMessage));
                    }

                    private void logAppropriateWarning(GrpcStatus status, String statusMessage) {
                        if (status == GrpcStatus.UNIMPLEMENTED) {
                            if (ClientRequestOnSuccessHandler.this.loggedUnimplemented.compareAndSet(false, true)) {
                                this.logUnimplemented(internalLogger, ClientRequestOnSuccessHandler.this.type, statusMessage);
                            }
                        } else if (status == GrpcStatus.UNAVAILABLE) {
                            ClientRequestOnSuccessHandler.this.logger.log(Level.WARNING, "Failed to export " + ClientRequestOnSuccessHandler.this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + statusMessage);
                        } else if (status == null) {
                            if (statusMessage == null) {
                                ClientRequestOnSuccessHandler.this.logger.log(Level.WARNING, "Failed to export " + ClientRequestOnSuccessHandler.this.type + "s. Perhaps the collector does not support collecting traces using grpc? Try configuring 'quarkus.otel.exporter.otlp.traces.protocol=http/protobuf'");
                            } else {
                                ClientRequestOnSuccessHandler.this.logger.log(Level.WARNING, "Failed to export " + ClientRequestOnSuccessHandler.this.type + "s. Server responded with error message: " + statusMessage);
                            }
                        } else {
                            ClientRequestOnSuccessHandler.this.logger.log(Level.WARNING, "Failed to export " + ClientRequestOnSuccessHandler.this.type + "s. Server responded with " + status.code + ". Error message: " + statusMessage);
                        }
                    }

                    private void logUnimplemented(Logger logger, String type, String fullErrorMessage) {
                        String envVar;
                        switch (type) {
                            case "span": {
                                envVar = "OTEL_TRACES_EXPORTER";
                                break;
                            }
                            case "metric": {
                                envVar = "OTEL_METRICS_EXPORTER";
                                break;
                            }
                            case "log": {
                                envVar = "OTEL_LOGS_EXPORTER";
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unrecognized type, this is a programming bug in the OpenTelemetry SDK");
                            }
                        }
                        logger.log(Level.WARNING, "Failed to export " + type + "s. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. If export is not desired and you are using OpenTelemetry autoconfiguration or the javaagent, disable export by setting " + envVar + "=none. Full error message: " + fullErrorMessage);
                    }

                    private GrpcStatus getStatus(GrpcClientResponse<?, ?> response) {
                        String statusFromTrailer;
                        GrpcStatus result = response.status();
                        if (result == null && (statusFromTrailer = response.trailers().get(VertxGrpcSender.GRPC_STATUS)) != null) {
                            result = GrpcStatus.valueOf((int)Integer.parseInt(statusFromTrailer));
                        }
                        return result;
                    }

                    private String getStatusMessage(GrpcClientResponse<Buffer, Buffer> response) {
                        String result = response.statusMessage();
                        if (result == null && (result = response.trailers().get(VertxGrpcSender.GRPC_MESSAGE)) != null) {
                            result = QueryStringDecoder.decodeComponent((String)result, (Charset)StandardCharsets.UTF_8);
                        }
                        return result;
                    }
                }).onFailure((Handler)new Handler<Throwable>(){

                    public void handle(Throwable t) {
                        if (ClientRequestOnSuccessHandler.this.attemptNumber <= 3 && !ClientRequestOnSuccessHandler.this.isShutdown.get().booleanValue()) {
                            VertxGrpcSender.this.initiateSend(ClientRequestOnSuccessHandler.this.marshaler, ClientRequestOnSuccessHandler.this.client, ClientRequestOnSuccessHandler.this.server, 3 - ClientRequestOnSuccessHandler.this.attemptNumber, ClientRequestOnSuccessHandler.this.newAttempt(), new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    ClientRequestOnSuccessHandler.this.failOnClientRequest(throwable, ClientRequestOnSuccessHandler.this.onError, ClientRequestOnSuccessHandler.this.attemptNumber);
                                }
                            });
                        } else {
                            ClientRequestOnSuccessHandler.this.failOnClientRequest(t, ClientRequestOnSuccessHandler.this.onError, ClientRequestOnSuccessHandler.this.attemptNumber);
                        }
                    }
                });
            }
            catch (IOException e) {
                String message = "Failed to export " + this.type + "s. Unable to serialize payload. Full error message: " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                this.logger.log(Level.WARNING, message);
                this.onError.accept(e);
            }
        }

        private void failOnClientRequest(Throwable t, Consumer<Throwable> onError, int attemptNumber) {
            String message = "Failed to export " + this.type + "s. The request could not be executed after " + attemptNumber + " attempts. Full error message: " + (t != null ? t.getMessage() : "");
            this.logger.log(Level.WARNING, message);
            onError.accept(t);
        }

        public ClientRequestOnSuccessHandler newAttempt() {
            return new ClientRequestOnSuccessHandler(this.client, this.server, this.headers, this.compressionEnabled, this.marshaler, this.loggedUnimplemented, this.logger, this.type, this.onSuccess, this.onError, this.attemptNumber + 1, this.grpcEndpointPath, this.isShutdown);
        }
    }
}

