/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.SloppyMath;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.GeoPointDistanceDocValues;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractNestingAwareAccumulatingValues;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneDistanceToFieldProjection<P>
extends AbstractLuceneProjection<P> {
    private static final ProjectionConverter<Double, Double> NO_OP_DOUBLE_CONVERTER = ProjectionConverter.passThrough(Double.class);
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final String requiredContextAbsoluteFieldPath;
    private final LuceneFieldCodec<GeoPoint, ?> codec;
    private final GeoPoint center;
    private final DistanceUnit unit;
    private final ProjectionAccumulator.Provider<Double, P> accumulatorProvider;
    private final LuceneFieldProjection<Double, Double, P, ?> fieldProjection;

    private LuceneDistanceToFieldProjection(Builder builder, ProjectionAccumulator.Provider<Double, P> accumulatorProvider) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.nestedDocumentPath = builder.field.nestedDocumentPath();
        this.requiredContextAbsoluteFieldPath = accumulatorProvider.isSingleValued() ? builder.field.closestMultiValuedParentAbsolutePath() : null;
        this.codec = builder.codec;
        this.center = builder.center;
        this.unit = builder.unit;
        this.accumulatorProvider = accumulatorProvider;
        this.fieldProjection = builder.field.multiValued() ? new LuceneFieldProjection(builder.scope, builder.field, this::computeDistanceWithUnit, NO_OP_DOUBLE_CONVERTER, accumulatorProvider) : null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + ", center=" + String.valueOf(this.center) + ", accumulatorProvider=" + String.valueOf(this.accumulatorProvider) + "]";
    }

    @Override
    public LuceneSearchProjection.Extractor<?, P> request(ProjectionRequestContext context) {
        if (this.fieldProjection != null) {
            return this.fieldProjection.request(context);
        }
        context.checkValidField(this.absoluteFieldPath);
        if (!context.projectionCardinalityCorrectlyAddressed(this.requiredContextAbsoluteFieldPath)) {
            throw log.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(this.absoluteFieldPath, this.requiredContextAbsoluteFieldPath);
        }
        return new DocValuesBasedDistanceExtractor(this.accumulatorProvider.get(), context.absoluteCurrentNestedFieldPath());
    }

    private Double computeDistanceWithUnit(IndexableField field) {
        GeoPoint decoded = this.codec.decode(field);
        if (decoded == null) {
            return null;
        }
        double distanceInMeters = SloppyMath.haversinMeters((double)this.center.latitude(), (double)this.center.longitude(), (double)decoded.latitude(), (double)decoded.longitude());
        return this.unit.fromMeters(Double.valueOf(distanceInMeters));
    }

    public static class Builder
    extends AbstractLuceneProjection.AbstractBuilder<Double>
    implements DistanceToFieldProjectionBuilder {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private final LuceneFieldCodec<GeoPoint, ?> codec;
        private final LuceneSearchIndexValueFieldContext<GeoPoint> field;
        private GeoPoint center;
        private DistanceUnit unit = DistanceUnit.METERS;

        private Builder(LuceneFieldCodec<GeoPoint, ?> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope);
            this.codec = codec;
            this.field = field;
        }

        public void center(GeoPoint center) {
            this.center = center;
        }

        public void unit(DistanceUnit unit) {
            this.unit = unit;
        }

        public <P> SearchProjection<P> build(ProjectionAccumulator.Provider<Double, P> accumulatorProvider) {
            if (accumulatorProvider.isSingleValued() && this.field.multiValued()) {
                throw log.invalidSingleValuedProjectionOnMultiValuedField(this.field.absolutePath(), this.field.eventContext());
            }
            return new LuceneDistanceToFieldProjection<P>(this, accumulatorProvider);
        }
    }

    private class DocValuesBasedDistanceExtractor<A>
    implements LuceneSearchProjection.Extractor<A, P> {
        private final ProjectionAccumulator<Double, Double, A, P> accumulator;
        private final String contextAbsoluteFieldPath;

        private DocValuesBasedDistanceExtractor(ProjectionAccumulator<Double, Double, A, P> accumulator, String contextAbsoluteFieldPath) {
            this.accumulator = accumulator;
            this.contextAbsoluteFieldPath = contextAbsoluteFieldPath;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[absoluteFieldPath=" + LuceneDistanceToFieldProjection.this.absoluteFieldPath + ", center=" + String.valueOf(LuceneDistanceToFieldProjection.this.center) + ", accumulator=" + String.valueOf(this.accumulator) + "]";
        }

        @Override
        public Values<A> values(ProjectionExtractContext context) {
            return new DocValuesBasedDistanceValues(context.collectorExecutionContext());
        }

        @Override
        public P transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            return this.accumulator.finish(extractedData);
        }

        private class DocValuesBasedDistanceValues
        extends AbstractNestingAwareAccumulatingValues<Double, A> {
            private GeoPointDistanceDocValues currentLeafValues;

            public DocValuesBasedDistanceValues(TopDocsDataCollectorExecutionContext context) {
                super(DocValuesBasedDistanceExtractor.this.contextAbsoluteFieldPath, LuceneDistanceToFieldProjection.this.nestedDocumentPath, DocValuesBasedDistanceExtractor.this.accumulator, context);
            }

            @Override
            protected DocIdSetIterator doContext(LeafReaderContext context) throws IOException {
                this.currentLeafValues = new GeoPointDistanceDocValues(DocValues.getSortedNumeric((LeafReader)context.reader(), (String)LuceneDistanceToFieldProjection.this.absoluteFieldPath), LuceneDistanceToFieldProjection.this.center);
                return this.currentLeafValues;
            }

            @Override
            protected A accumulate(A accumulated, int docId) throws IOException {
                if (this.currentLeafValues.advanceExact(docId)) {
                    for (int i = 0; i < this.currentLeafValues.docValueCount(); ++i) {
                        Double distanceOrNull = this.currentLeafValues.nextValue();
                        accumulated = this.accumulator.accumulate(accumulated, (Object)LuceneDistanceToFieldProjection.this.unit.fromMeters(distanceOrNull));
                    }
                }
                return accumulated;
            }
        }
    }

    public static class Factory
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<DistanceToFieldProjectionBuilder, GeoPoint, LuceneFieldCodec<GeoPoint, byte[]>> {
        public Factory(LuceneFieldCodec<GeoPoint, byte[]> codec) {
            super(codec);
        }

        @Override
        public Builder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            field.nestedPathHierarchy();
            return new Builder(this.codec, scope, field);
        }
    }
}

