/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.Set;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.dsl.AggregationFinalStep;
import org.hibernate.search.engine.search.aggregation.spi.WithParametersAggregationBuilder;
import org.hibernate.search.engine.search.common.NamedValues;

public class LuceneWithParametersAggregation<A>
implements LuceneSearchAggregation<A> {
    private final LuceneSearchIndexScope<?> scope;
    private final Function<? super NamedValues, ? extends AggregationFinalStep<A>> aggregationCreator;

    private LuceneWithParametersAggregation(Builder<A> builder) {
        this.scope = builder.scope;
        this.aggregationCreator = builder.aggregationCreator;
    }

    @Override
    public LuceneSearchAggregation.Extractor<A> request(AggregationRequestContext context) {
        SearchAggregation aggregation = this.aggregationCreator.apply((NamedValues)context.queryParameters()).toAggregation();
        return LuceneSearchAggregation.from(this.scope, aggregation).request(context);
    }

    @Override
    public Set<String> indexNames() {
        return this.scope.hibernateSearchIndexNames();
    }

    public static class Builder<A>
    implements WithParametersAggregationBuilder<A> {
        protected final LuceneSearchIndexScope<?> scope;
        private Function<? super NamedValues, ? extends AggregationFinalStep<A>> aggregationCreator;

        public Builder(LuceneSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        public LuceneSearchAggregation<A> build() {
            return new LuceneWithParametersAggregation(this);
        }

        public void creator(Function<? super NamedValues, ? extends AggregationFinalStep<A>> aggregationCreator) {
            this.aggregationCreator = aggregationCreator;
        }
    }
}

