/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.util.StrictSizeTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.MountHandle;

public abstract class DeploymentHandler
extends BatchModeCommandHandler {
    static final String CLI_ARCHIVE_SUFFIX = ".cli";

    public DeploymentHandler(CommandContext ctx, String command, boolean connectionRequired) {
        super(ctx, command, connectionRequired);
    }

    protected void listDeployments(CommandContext ctx, boolean l) throws CommandFormatException {
        if (!l) {
            this.printList(ctx, Util.getDeployments(ctx.getModelControllerClient()), l);
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        List<String> names = Util.getDeployments(client);
        if (names.isEmpty()) {
            return;
        }
        StrictSizeTable table = new StrictSizeTable(names.size());
        List descriptions = this.getDeploymentDescriptions(ctx, names).asPropertyList();
        for (Property prop : descriptions) {
            ModelNode step = prop.getValue();
            if (step.hasDefined("result")) {
                ModelNode result = step.get("result");
                table.addCell("name", result.get("name").asString());
                table.addCell("runtime-name", result.get("runtime-name").asString());
                if (result.has("enabled")) {
                    table.addCell("enabled", result.get("enabled").asString());
                }
                if (result.has("status")) {
                    table.addCell("status", result.get("status").asString());
                }
            }
            if (table.isAtLastRow()) continue;
            table.nextRow();
        }
        ctx.printLine(table.toString());
    }

    protected ModelNode getDeploymentDescriptions(CommandContext ctx, List<String> names) throws CommandFormatException {
        ModelNode result;
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (String name : names) {
            ModelNode deploymentResource = this.buildReadDeploymentResourceRequest(name);
            if (deploymentResource == null) continue;
            steps.add(deploymentResource);
        }
        try {
            result = ctx.getModelControllerClient().execute(composite);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute operation request.", e);
        }
        if (!result.hasDefined("result")) {
            return null;
        }
        return result.get("result");
    }

    protected ModelNode buildReadDeploymentResourceRequest(String name) {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        address.add("deployment", name);
        request.get("operation").set("read-resource");
        request.get("include-runtime").set(true);
        return request;
    }

    protected MountHandle extractArchive(File archive, TempFileProvider tempFileProvider) throws IOException {
        return (MountHandle)VFS.mountZipExpanded((File)archive, (VirtualFile)VFS.getChild((String)"cli"), (TempFileProvider)tempFileProvider);
    }

    protected String activateNewBatch(CommandContext ctx) {
        String currentBatch = null;
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            currentBatch = "batch" + System.currentTimeMillis();
            batchManager.holdbackActiveBatch(currentBatch);
        }
        batchManager.activateNewBatch();
        return currentBatch;
    }

    protected void discardBatch(CommandContext ctx, String holdbackBatch) {
        BatchManager batchManager = ctx.getBatchManager();
        batchManager.discardActiveBatch();
        if (holdbackBatch != null) {
            batchManager.activateHeldbackBatch(holdbackBatch);
        }
    }

    protected boolean isCliArchive(File f) {
        return f != null && !f.isDirectory() && f.getName().endsWith(CLI_ARCHIVE_SUFFIX);
    }
}

