/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotationIndex;
import org.wildfly.unstable.api.annotation.classpath.index.JarAnnotationIndex;
import org.wildfly.unstable.api.annotation.classpath.index.JarAnnotationIndexer;

public class OverallIndex {
    private final Map<String, AnnotationIndex> indexes;

    public OverallIndex() {
        this.indexes = new HashMap<String, AnnotationIndex>();
    }

    private OverallIndex(Map<String, AnnotationIndex> indexes) {
        this.indexes = indexes;
    }

    public void scanJar(File jar, String annotation) throws IOException {
        JarAnnotationIndexer indexer = new JarAnnotationIndexer(jar, annotation, Collections.emptySet());
        JarAnnotationIndex jarAnnotationIndex = indexer.scanForAnnotation();
        this.mergeAnnotationIndex(jarAnnotationIndex);
    }

    public void scanJar(File jar, String annotation, Set<String> excludedClasses) throws IOException {
        JarAnnotationIndexer indexer = new JarAnnotationIndexer(jar, annotation, excludedClasses);
        JarAnnotationIndex jarAnnotationIndex = indexer.scanForAnnotation();
        this.mergeAnnotationIndex(jarAnnotationIndex);
    }

    private void merge(OverallIndex index) {
        for (AnnotationIndex ai : index.indexes.values()) {
            this.mergeAnnotationIndex(ai);
        }
    }

    private void mergeAnnotationIndex(AnnotationIndex annotationIndex) {
        AnnotationIndex index = this.indexes.get(annotationIndex.getAnnotationName());
        if (index == null) {
            index = new AnnotationIndex(annotationIndex);
            this.indexes.put(annotationIndex.getAnnotationName(), index);
        } else {
            index.addIndexEntries(annotationIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Path path) throws IOException {
        Format format = OverallIndex.determineFormat(path.getFileName().toString());
        if (format == null) {
            throw new IllegalArgumentException("Suffix of file should be .txt or .zip");
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        if (format == Format.TEXT) {
            Files.createFile(path, new FileAttribute[0]);
            this.saveIndex(path);
        } else {
            Path tempIndex = Files.createTempFile("working", ".txt", new FileAttribute[0]);
            try {
                this.saveIndex(tempIndex);
                URI jarUri = URI.create("jar:file:" + path.normalize().toAbsolutePath().toUri().getPath());
                Map<String, String> env = Map.of("create", "true");
                try (FileSystem jar = FileSystems.newFileSystem(jarUri, env);){
                    Path jarPath = jar.getPath("index.txt", new String[0]);
                    Files.copy(tempIndex, jarPath, new CopyOption[0]);
                }
            }
            finally {
                Files.delete(tempIndex);
            }
        }
    }

    private void saveIndex(Path path) throws IOException {
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(path.toFile())));){
            for (AnnotationIndex annotationIndex : this.indexes.values()) {
                annotationIndex.save(writer);
            }
        }
    }

    public Set<String> getAnnotations() {
        return this.indexes.keySet();
    }

    public AnnotationIndex getAnnotationIndex(String annotation) {
        return this.indexes.get(annotation);
    }

    static OverallIndex load(Path path, Path ... additional) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            throw new FileNotFoundException(path.toString());
        }
        OverallIndex index = OverallIndex.loadIndex(path);
        for (Path additionalPath : additional) {
            index.merge(OverallIndex.loadIndex(additionalPath));
        }
        return index;
    }

    static OverallIndex load(List<URL> urls) throws IOException {
        OverallIndex index = null;
        for (URL url : urls) {
            if (index == null) {
                index = OverallIndex.loadIndex(url);
                continue;
            }
            index.merge(OverallIndex.loadIndex(url));
        }
        return index;
    }

    private static OverallIndex loadIndex(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            throw new FileNotFoundException(path.toString());
        }
        return OverallIndex.loadIndex(path.toUri().toURL());
    }

    /*
     * Exception decompiling
     */
    private static OverallIndex loadIndex(URL url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static OverallIndex readFromInputStream(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            Map<String, AnnotationIndex> indexes = AnnotationIndex.loadAll(reader);
            OverallIndex overallIndex = new OverallIndex(indexes);
            return overallIndex;
        }
    }

    private static String determineSuffix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return fileName.substring(index);
    }

    private static Format determineFormat(String fileName) {
        String suffix = OverallIndex.determineSuffix(fileName);
        return Format.find(suffix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverallIndex)) {
            return false;
        }
        OverallIndex that = (OverallIndex)o;
        return Objects.equals(this.indexes, that.indexes);
    }

    public static enum Format {
        TEXT(".txt"),
        ZIP(".zip");

        private final String suffix;

        private Format(String suffix) {
            this.suffix = suffix;
        }

        static Format find(String suffix) {
            if (suffix == null) {
                return null;
            }
            switch (suffix) {
                case ".txt": {
                    return TEXT;
                }
                case ".zip": {
                    return ZIP;
                }
            }
            return null;
        }
    }
}

