/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonServerReceiverContext
extends ProtonAbstractReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SimpleString address;
    protected SimpleString lastAddress;
    protected AddressFullMessagePolicy lastAddressPolicy;
    protected boolean addressAlreadyClashed = false;
    protected final Runnable spiFlow = this::sessionSPIFlow;
    protected RoutingType defRoutingType;

    public ProtonServerReceiverContext(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver) {
        super(sessionSPI, connection, protonSession, receiver);
    }

    @Override
    public void initialize() throws Exception {
        this.initialized = true;
        Target target = (Target)this.receiver.getRemoteTarget();
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        if (target != null) {
            List<Symbol> list;
            if (target.getDynamic()) {
                this.address = SimpleString.of((String)this.sessionSPI.tempQueueName());
                this.defRoutingType = this.getRoutingType(target.getCapabilities(), this.address);
                try {
                    this.sessionSPI.createTemporaryQueue(this.address, this.defRoutingType);
                }
                catch (ActiveMQAMQPSecurityException e) {
                    throw e;
                }
                catch (ActiveMQSecurityException e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingTempDestination(e.getMessage());
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
                target.setAddress(this.address.toString());
            } else {
                String targetAddress = target.getAddress();
                if (targetAddress != null && !targetAddress.isEmpty()) {
                    this.address = SimpleString.of((String)targetAddress);
                }
                if (this.address != null) {
                    this.defRoutingType = this.getRoutingType(target.getCapabilities(), this.address);
                    try {
                        if (!this.sessionSPI.checkAddressAndAutocreateIfPossible(this.address, this.defRoutingType)) {
                            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(this.address.toString());
                        }
                    }
                    catch (ActiveMQAMQPNotFoundException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                        throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                    }
                    SimpleString addressPart = CompositeAddress.extractAddressName((SimpleString)this.address);
                    SimpleString queuePart = CompositeAddress.isFullyQualified((SimpleString)this.address) ? CompositeAddress.extractQueueName((SimpleString)this.address) : null;
                    try {
                        this.sessionSPI.check(addressPart, queuePart, CheckType.SEND, this.connection.getSecurityAuth());
                    }
                    catch (ActiveMQSecurityException e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingProducer(e.getMessage());
                    }
                }
            }
            Symbol[] remoteDesiredCapabilities = this.receiver.getRemoteDesiredCapabilities();
            if (remoteDesiredCapabilities != null && (list = Arrays.asList(remoteDesiredCapabilities)).contains(AmqpSupport.DELAYED_DELIVERY)) {
                this.receiver.setOfferedCapabilities(new Symbol[]{AmqpSupport.DELAYED_DELIVERY});
            }
        }
        this.flow();
    }

    public RoutingType getDefRoutingType() {
        return this.defRoutingType;
    }

    public RoutingType getRoutingType(Receiver receiver, SimpleString address) {
        Target target = (Target)receiver.getRemoteTarget();
        return target != null ? this.getRoutingType(target.getCapabilities(), address) : this.getRoutingType((Symbol[])null, address);
    }

    protected RoutingType getRoutingType(Symbol[] symbols, SimpleString address) {
        RoutingType explicitRoutingType = this.getExplicitRoutingType(symbols);
        if (explicitRoutingType != null) {
            return explicitRoutingType;
        }
        AddressInfo addressInfo = this.sessionSPI.getAddress(address);
        if (addressInfo != null && addressInfo.getRoutingTypes().size() == 1) {
            return addressInfo.getRoutingType();
        }
        return this.getDefaultRoutingType(address);
    }

    private RoutingType getDefaultRoutingType(SimpleString address) {
        RoutingType defaultRoutingType = this.sessionSPI.getRoutingTypeFromPrefix(address, this.sessionSPI.getDefaultRoutingType(address));
        return defaultRoutingType == null ? ActiveMQDefaultConfiguration.getDefaultRoutingType() : defaultRoutingType;
    }

    private RoutingType getExplicitRoutingType(Symbol[] symbols) {
        if (symbols != null) {
            for (Symbol symbol : symbols) {
                if (AmqpSupport.TEMP_TOPIC_CAPABILITY.equals(symbol) || AmqpSupport.TOPIC_CAPABILITY.equals(symbol)) {
                    return RoutingType.MULTICAST;
                }
                if (!AmqpSupport.TEMP_QUEUE_CAPABILITY.equals(symbol) && !AmqpSupport.QUEUE_CAPABILITY.equals(symbol)) continue;
                return RoutingType.ANYCAST;
            }
        }
        return null;
    }

    @Override
    protected void actualDelivery(Message message, Delivery delivery, DeliveryAnnotations deliveryAnnotations, Receiver receiver, Transaction tx) {
        try {
            if (this.sessionSPI != null) {
                if (this.address == null && message != null) {
                    this.validateAddressOnAnonymousLink(message);
                }
                this.sessionSPI.serverSend(this, tx, receiver, delivery, this.address, this.routingContext, message);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.deliveryFailed(delivery, receiver, e);
        }
    }

    private void validateAddressOnAnonymousLink(Message message) throws Exception {
        SimpleString newAddress = message.getAddressSimpleString();
        if (newAddress != null && !newAddress.equals((Object)this.lastAddress)) {
            AddressFullMessagePolicy currentPolicy = this.sessionSPI.getProtocolManager().getServer().getPagingManager().getPageStore(newAddress).getAddressFullMessagePolicy();
            if (this.lastAddressPolicy != null && this.lastAddressPolicy != currentPolicy) {
                if (!this.addressAlreadyClashed) {
                    this.addressAlreadyClashed = true;
                    ActiveMQAMQPProtocolLogger.LOGGER.incompatibleAddressFullMessagePolicy(this.lastAddress.toString(), String.valueOf(this.lastAddressPolicy), newAddress.toString(), String.valueOf(currentPolicy));
                }
                logger.debug("AddressFullPolicy clash between {}/{} and {}/{}", new Object[]{this.lastAddress, this.lastAddressPolicy, newAddress, this.lastAddressPolicy});
            }
            this.lastAddress = message.getAddressSimpleString();
            this.lastAddressPolicy = currentPolicy;
        }
    }

    public void deliveryFailed(Delivery delivery, Receiver receiver, Exception e) {
        this.connection.runNow(() -> {
            DeliveryState deliveryState = this.determineDeliveryState((Source)receiver.getSource(), this.useModified, e);
            delivery.disposition(deliveryState);
            this.settle(delivery);
            this.connection.flush();
        });
    }

    private DeliveryState determineDeliveryState(Source source, boolean useModified, Exception e) {
        Outcome defaultOutcome = this.getEffectiveDefaultOutcome(source);
        if (this.isAddressFull(e) && useModified && (this.outcomeSupported(source, Modified.DESCRIPTOR_SYMBOL) || defaultOutcome instanceof Modified)) {
            Modified modified = new Modified();
            modified.setDeliveryFailed(Boolean.valueOf(true));
            return modified;
        }
        if (this.outcomeSupported(source, Rejected.DESCRIPTOR_SYMBOL) || defaultOutcome instanceof Rejected) {
            return this.createRejected(e);
        }
        if (source.getDefaultOutcome() instanceof DeliveryState) {
            return (DeliveryState)source.getDefaultOutcome();
        }
        return this.createRejected(e);
    }

    private boolean isAddressFull(Exception e) {
        return e instanceof ActiveMQException && ActiveMQExceptionType.ADDRESS_FULL.equals((Object)((ActiveMQException)((Object)e)).getType());
    }

    private Rejected createRejected(Exception e) {
        ErrorCondition condition = new ErrorCondition();
        if (e instanceof ActiveMQSecurityException) {
            condition.setCondition(AmqpError.UNAUTHORIZED_ACCESS);
        } else if (this.isAddressFull(e)) {
            condition.setCondition(AmqpError.RESOURCE_LIMIT_EXCEEDED);
        } else {
            condition.setCondition(Symbol.valueOf((String)"failed"));
        }
        condition.setDescription(e.getMessage());
        Rejected rejected = new Rejected();
        rejected.setError(condition);
        return rejected;
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        super.close(remoteLinkClose);
        this.sessionSPI.removeProducer(this.receiver.getName());
        Target target = (Target)this.receiver.getRemoteTarget();
        if (target != null && target.getDynamic() && (target.getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH || target.getExpiryPolicy() == TerminusExpiryPolicy.SESSION_END)) {
            try {
                this.sessionSPI.removeTemporaryQueue(SimpleString.of((String)target.getAddress()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void flow() {
        this.connection.afterFlush(this.spiFlow);
    }

    protected void sessionSPIFlow() {
        this.connection.requireInHandler();
        if (this.sessionSPI != null) {
            this.sessionSPI.flow(this.address != null ? this.address : this.lastAddress, this.creditRunnable);
        } else {
            this.creditRunnable.run();
        }
    }

    public void drain(int credits) {
        this.connection.runNow(() -> {
            this.receiver.drain(credits);
            this.connection.flush();
        });
    }

    public int drained() {
        return this.receiver.drained();
    }

    public boolean isDraining() {
        return this.receiver.draining();
    }

    private boolean outcomeSupported(Source source, Symbol outcome) {
        if (source != null && source.getOutcomes() != null) {
            return Arrays.asList(source.getOutcomes()).contains(outcome);
        }
        return false;
    }

    private Outcome getEffectiveDefaultOutcome(Source source) {
        return source.getOutcomes() == null || source.getOutcomes().length == 0 ? source.getDefaultOutcome() : null;
    }
}

