/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.provider;

import java.util.List;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrarConfiguration;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.clustering.server.provider.ServiceProviderRegistrarServiceInstallerFactory;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheServiceProviderRegistrarServiceInstallerFactory<T>
extends ServiceProviderRegistrarServiceInstallerFactory<T> {
    public ServiceInstaller apply(CapabilityServiceSupport support, BinaryServiceConfiguration configuration) {
        final ServiceDependency group = configuration.getServiceDependency(ClusteringServiceDescriptor.GROUP).map(CacheContainerGroup.class::cast);
        final ServiceDependency cache = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        final ServiceName name = configuration.resolveServiceName(this.getServiceDescriptor());
        final CacheServiceProviderRegistrarConfiguration config = new CacheServiceProviderRegistrarConfiguration(){

            public <K, V> Cache<K, V> getCache() {
                return (Cache)cache.get();
            }

            public Object getId() {
                return name;
            }

            public CacheContainerGroup getGroup() {
                return (CacheContainerGroup)group.get();
            }
        };
        Supplier<CacheServiceProviderRegistrar<Object>> factory = new Supplier<CacheServiceProviderRegistrar<Object>>(){

            @Override
            public CacheServiceProviderRegistrar<Object> get() {
                return new CacheServiceProviderRegistrar(config);
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).blocking()).provides(name)).requires(List.of(group, cache))).onStop(Functions.closingConsumer())).build();
    }
}

