/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.git;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.ElytronXmlParser;

class ElytronClientCredentialsProvider
extends CredentialsProvider {
    private static AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final AuthenticationContext context;

    ElytronClientCredentialsProvider(URI authenticationConfig) throws ConfigXMLParseException, GeneralSecurityException {
        this.context = (AuthenticationContext)ElytronXmlParser.parseAuthenticationClientConfiguration((URI)authenticationConfig).create();
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        try {
            AuthenticationConfiguration config = CLIENT.getAuthenticationConfiguration(new URI(uri.toString()), this.context);
            for (CredentialItem i : items) {
                Callback[] callbacks;
                Callback callback;
                if (i instanceof CredentialItem.Username) {
                    callback = new NameCallback("git username");
                    callbacks = new Callback[]{callback};
                    CLIENT.getCallbackHandler(config).handle(callbacks);
                    ((CredentialItem.Username)i).setValue(((NameCallback)callback).getName());
                    continue;
                }
                if (i instanceof CredentialItem.Password) {
                    callback = new PasswordCallback("git username", false);
                    callbacks = new Callback[]{callback};
                    CLIENT.getCallbackHandler(config).handle(callbacks);
                    ((CredentialItem.Password)i).setValue(((PasswordCallback)callback).getPassword());
                    continue;
                }
                if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                    callback = new PasswordCallback("git username", false);
                    callbacks = new Callback[]{callback};
                    CLIENT.getCallbackHandler(config).handle(callbacks);
                    ((CredentialItem.StringType)i).setValue(new String(((PasswordCallback)callback).getPassword()));
                    continue;
                }
                throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
            }
        }
        catch (IOException | URISyntaxException | UnsupportedCallbackException ex) {
            throw new UnsupportedCredentialItem(uri, ex.getMessage());
        }
        return true;
    }
}

