/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration;

import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InVMCloseTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.start();
    }

    @Test
    public void validateCloseLogging() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler(true);){
            session.close();
            sf.close();
            locator.close();
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ212037"}));
            Assertions.assertEquals((int)0, (int)loggerHandler.getNumberOfMessages(), (String)"Logger should be silent for the close operation.");
        }
    }
}

