/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpFailoverEndpointDiscoveryTest
extends FailoverTestBase {
    private final int protocol;

    @Parameters(name="{0}")
    public static Collection<?> getParameters() {
        return Arrays.asList(new Object[][]{{"NON_SSL", 0}});
    }

    public AmqpFailoverEndpointDiscoveryTest(String name, int protocol) {
        this.protocol = protocol;
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = this.createNodeManager();
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultNettyConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(this.createBasicClusterConfig(backupConnector.getName(), primaryConnector.getName()));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig = super.createDefaultNettyConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(this.createBasicClusterConfig(primaryConnector.getName(), new String[0])).addConnectorConfiguration(primaryConnector.getName(), primaryConnector);
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfig(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfig(live);
    }

    @TestTemplate
    @Timeout(value=120L)
    public void testFailoverListWithAMQP() throws Exception {
        JmsConnectionFactory factory = this.getJmsConnectionFactory();
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(ADDRESS.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello before failover"));
            this.primaryServer.crash(true, true, new ClientSession[0]);
            producer.send((Message)session.createTextMessage("hello after failover"));
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage receive = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)receive);
            Assertions.assertEquals((Object)"hello before failover", (Object)receive.getText());
            receive = (TextMessage)consumer.receive(5000L);
            Assertions.assertEquals((Object)"hello after failover", (Object)receive.getText());
            Assertions.assertNotNull((Object)receive);
        }
    }

    private JmsConnectionFactory getJmsConnectionFactory() {
        if (this.protocol == 0) {
            return new JmsConnectionFactory("failover:(amqp://localhost:61616)");
        }
        String keystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("client-keystore.jks").getFile();
        String truststore = ((Object)((Object)this)).getClass().getClassLoader().getResource("server-ca-truststore.jks").getFile();
        return new JmsConnectionFactory("failover:(amqps://localhost:61616?transport.keyStoreLocation=" + keystore + "&transport.keyStorePassword=securepass&transport.trustStoreLocation=" + truststore + "&transport.trustStorePassword=securepass&transport.verifyHost=false)");
    }

    private TransportConfiguration getNettyAcceptorTransportConfig(boolean live) {
        HashMap<String, Object> server1Params = new HashMap<String, Object>();
        if (this.protocol == 1) {
            server1Params.put("sslEnabled", "true");
            server1Params.put("keyStorePath", "server-keystore.jks");
            server1Params.put("keyStorePassword", "securepass");
            server1Params.put("trustStorePath", "client-ca-truststore.jks");
            server1Params.put("trustStorePassword", "securepass");
        }
        if (live) {
            return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, server1Params);
        }
        server1Params.put("port", 61617);
        return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, server1Params);
    }

    private TransportConfiguration getNettyConnectorTransportConfig(boolean live) {
        HashMap<String, Object> server1Params = new HashMap<String, Object>();
        if (this.protocol == 1) {
            server1Params.put("sslEnabled", true);
            server1Params.put("trustStorePath", "server-ca-truststore.jks");
            server1Params.put("trustStorePassword", "securepass");
            server1Params.put("keyStorePath", "client-keystore.jks");
            server1Params.put("keyStorePassword", "securepass");
        }
        if (live) {
            return new TransportConfiguration(NETTY_CONNECTOR_FACTORY, server1Params);
        }
        server1Params.put("port", 61617);
        return new TransportConfiguration(NETTY_CONNECTOR_FACTORY, server1Params);
    }
}

