/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpIngressTimestampTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public int amqpMinLargeMessageSize = 102400;
    @Parameter(index=0)
    public boolean restart;
    @Parameter(index=1)
    public boolean large;

    @Parameters(name="restart={0}, large={1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true, true}, {false, false}, {true, false}, {false, true});
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testIngressTimestampSendCore() throws Exception {
        this.internalTestIngressTimestamp(Protocol.CORE);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testIngressTimestampSendAMQP() throws Exception {
        this.internalTestIngressTimestamp(Protocol.AMQP);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testIngressTimestampSendOpenWire() throws Exception {
        this.internalTestIngressTimestamp(Protocol.OPENWIRE);
    }

    private void internalTestIngressTimestamp(Protocol protocol) throws Exception {
        String QUEUE_NAME = RandomUtil.randomString();
        this.server.createQueue(QueueConfiguration.of((String)QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        this.server.getAddressSettingsRepository().addMatch(QUEUE_NAME, (Object)new AddressSettings().setEnableIngressTimestamp(true));
        long beforeSend = System.currentTimeMillis();
        if (protocol == Protocol.CORE) {
            this.sendMessagesCore(QUEUE_NAME, 1, true, this.getMessagePayload());
        } else if (protocol == Protocol.OPENWIRE) {
            this.sendMessagesOpenWire(QUEUE_NAME, 1, true, this.getMessagePayload());
        } else {
            this.sendMessages(QUEUE_NAME, 1, true, this.getMessagePayload());
        }
        long afterSend = System.currentTimeMillis();
        if (this.restart) {
            this.server.stop();
            this.server.start();
            Assertions.assertTrue((boolean)this.server.waitForActivation(3L, TimeUnit.SECONDS));
        }
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(QUEUE_NAME);
        Queue queueView = this.getProxyToQueue(QUEUE_NAME);
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessageCount(), (long)2000L, (long)100L, (boolean)false);
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)receive);
        logger.info("{}", (Object)receive);
        Object ingressTimestampHeader = receive.getMessageAnnotation("x-opt-ingress-time");
        Assertions.assertNotNull((Object)ingressTimestampHeader);
        Assertions.assertTrue((boolean)(ingressTimestampHeader instanceof Long));
        long ingressTimestamp = (Long)ingressTimestampHeader;
        Assertions.assertTrue((ingressTimestamp >= beforeSend && ingressTimestamp <= afterSend ? 1 : 0) != 0, (String)("Ingress timstamp " + ingressTimestamp + " should be >= " + beforeSend + " and <= " + afterSend));
        receiver.close();
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected void setData(AmqpMessage amqpMessage) throws Exception {
        amqpMessage.setBytes(this.getMessagePayload());
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("amqpMinLargeMessageSize", 102400);
    }

    private byte[] getMessagePayload() {
        StringBuilder result = new StringBuilder();
        if (this.large) {
            for (int i = 0; i < 2048000; ++i) {
                result.append("AB");
            }
        } else {
            result.append("AB");
        }
        return result.toString().getBytes();
    }

    private static enum Protocol {
        CORE,
        AMQP,
        OPENWIRE;

    }
}

