/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.messaging.Terminus;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.engine.Receiver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpNonDurableReceiverTest
extends AmqpClientTestSupport {
    @Test
    @Timeout(value=60L)
    public void testLinkDetachReleasesResources() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.connect();
        AmqpSession session = connection.createSession();
        SimpleString simpleTopicName = SimpleString.of((String)this.getTopicName());
        int bindingsBefore = this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().size();
        AmqpReceiver receiver = session.createReceiver(this.getTopicName());
        final AtomicBoolean remoteLinkClosed = new AtomicBoolean();
        Assertions.assertEquals((Object)TerminusExpiryPolicy.LINK_DETACH, (Object)((Terminus)((Receiver)receiver.getEndpoint()).getSource()).getExpiryPolicy(), (String)"Unexpected source expiry policy");
        receiver.setStateInspector(new AmqpValidator(){

            @Override
            public void inspectDetachedResource(Receiver receiver) {
                super.inspectDetachedResource(receiver);
                Assertions.fail((String)"Remote link detached in unexpected manner");
            }

            @Override
            public void inspectClosedResource(Receiver receiver) {
                super.inspectClosedResource(receiver);
                remoteLinkClosed.set(true);
            }
        });
        Assertions.assertEquals((int)(bindingsBefore + 1), (int)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().size(), (String)"Unexpected number of bindings before attach");
        receiver.detach();
        Assertions.assertEquals((int)bindingsBefore, (int)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().size(), (String)"Unexpected number of bindings after detach");
        Assertions.assertTrue((boolean)remoteLinkClosed.get(), (String)"Remote link was not closed");
        receiver.getStateInspector().assertValid();
    }
}

