/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AutoCreateWithDefaultRoutingTypesTest
extends JMSClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Parameter(index=0)
    public RoutingType routingType;

    @Parameters(name="routingType={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({RoutingType.ANYCAST}, {RoutingType.MULTICAST});
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP";
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("anycastPrefix", "anycast://");
        params.put("multicastPrefix", "multicast://");
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        Configuration serverConfig = server.getConfiguration();
        serverConfig.setJournalType(JournalType.NIO);
        Map map = serverConfig.getAddressSettings();
        if (map.size() == 0) {
            AddressSettings as = new AddressSettings();
            map.put("#", as);
        }
        Map.Entry entry = map.entrySet().iterator().next();
        AddressSettings settings = (AddressSettings)entry.getValue();
        settings.setAutoCreateQueues(Boolean.valueOf(true));
        settings.setDefaultAddressRoutingType(this.routingType);
        logger.info("server config, isauto? {}", (Object)((AddressSettings)entry.getValue()).isAutoCreateQueues());
        logger.info("server config, default address routing type? {}", (Object)((AddressSettings)entry.getValue()).getDefaultAddressRoutingType());
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateSender() throws Exception {
        String addressName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(addressName);
        AddressQueryResult address = this.getProxyToAddress(addressName);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(this.routingType), (Object)address.getRoutingTypes());
        AmqpReceiver receiver = session.createReceiver(addressName);
        receiver.flow(1);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        sender.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateReceiver() throws Exception {
        String addressName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(addressName);
        receiver.flow(1);
        AddressQueryResult address = this.getProxyToAddress(addressName);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(this.routingType), (Object)address.getRoutingTypes());
        AmqpSender sender = session.createSender(addressName);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        sender.close();
        receiver.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateSenderThatRequestsMultiCast() throws Exception {
        this.dotestCreateSenderThatRequestsSpecificRoutingType(RoutingType.MULTICAST);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateSenderThatRequestsAnyCast() throws Exception {
        this.dotestCreateSenderThatRequestsSpecificRoutingType(RoutingType.ANYCAST);
    }

    private void dotestCreateSenderThatRequestsSpecificRoutingType(RoutingType routingType) throws Exception {
        String addressName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Target target = new Target();
        target.setAddress(addressName);
        if (routingType == RoutingType.ANYCAST) {
            target.setCapabilities(new Symbol[]{AmqpDestinationHelper.QUEUE_CAPABILITY});
        } else {
            target.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY});
        }
        AmqpSender sender = session.createSender(target);
        AddressQueryResult address = this.getProxyToAddress(addressName);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(routingType), (Object)address.getRoutingTypes());
        AmqpReceiver receiver = session.createReceiver(addressName);
        receiver.flow(1);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        sender.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateReceiverThatRequestsMultiCast() throws Exception {
        this.dotestCreateReceiverThatRequestsSpecificRoutingType(RoutingType.MULTICAST);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateReceiverThatRequestsAnyCast() throws Exception {
        this.dotestCreateReceiverThatRequestsSpecificRoutingType(RoutingType.ANYCAST);
    }

    private void dotestCreateReceiverThatRequestsSpecificRoutingType(RoutingType routingType) throws Exception {
        String addressName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Source source = new Source();
        source.setAddress(addressName);
        if (routingType == RoutingType.ANYCAST) {
            source.setCapabilities(new Symbol[]{AmqpDestinationHelper.QUEUE_CAPABILITY});
        } else {
            source.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY});
        }
        AmqpReceiver receiver = session.createReceiver(source);
        receiver.flow(1);
        AddressQueryResult address = this.getProxyToAddress(addressName);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(routingType), (Object)address.getRoutingTypes());
        AmqpSender sender = session.createSender(addressName);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        sender.close();
        receiver.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateSenderThatRequestsMultiCastViaPrefix() throws Exception {
        this.dotestCreateSenderThatRequestsSpecificRoutingTypeViaPrefix(RoutingType.MULTICAST);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateSenderThatRequestsAnyCastViaPrefix() throws Exception {
        this.dotestCreateSenderThatRequestsSpecificRoutingTypeViaPrefix(RoutingType.ANYCAST);
    }

    private void dotestCreateSenderThatRequestsSpecificRoutingTypeViaPrefix(RoutingType routingType) throws Exception {
        String addressName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String prefixedName = routingType == RoutingType.ANYCAST ? "anycast://" + addressName : "multicast://" + addressName;
        AmqpSender sender = session.createSender(prefixedName);
        AddressQueryResult address = this.getProxyToAddress(addressName);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(routingType), (Object)address.getRoutingTypes());
        AmqpReceiver receiver = session.createReceiver(addressName);
        receiver.flow(1);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        sender.close();
        receiver.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateReceiverThatRequestsMultiCastViaPrefix() throws Exception {
        this.dotestCreateReceiverThatRequestsSpecificRoutingTypeViaPrefix(RoutingType.MULTICAST);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testCreateReceiverThatRequestsAnyCastViaPrefix() throws Exception {
        this.dotestCreateReceiverThatRequestsSpecificRoutingTypeViaPrefix(RoutingType.ANYCAST);
    }

    private void dotestCreateReceiverThatRequestsSpecificRoutingTypeViaPrefix(RoutingType routingType) throws Exception {
        String addressName = this.getTestName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String prefixedName = routingType == RoutingType.ANYCAST ? "anycast://" + addressName : "multicast://" + addressName;
        AmqpReceiver receiver = session.createReceiver(prefixedName);
        receiver.flow(1);
        AddressQueryResult address = this.getProxyToAddress(addressName);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(routingType), (Object)address.getRoutingTypes());
        AmqpSender sender = session.createSender(addressName);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        sender.close();
        receiver.close();
        connection.close();
    }

    public AddressQueryResult getProxyToAddress(String addressName) throws Exception {
        return this.server.addressQuery(SimpleString.of((String)addressName));
    }
}

