/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.client.AMQPClientConnectionFactory;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientConnectionManager;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.sasl.ExternalMechanism;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Connection;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSSaslExternalTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final boolean debug = false;

    @BeforeEach
    public void initialise() throws Exception {
        this.setUpDebug();
        this.startServer();
    }

    protected void setUpDebug() throws Exception {
    }

    protected void startServer() throws Exception {
        ConfigurationImpl configuration = this.createBasicConfig(0).setJMXManagementEnabled(false);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration.setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("saslMechanisms", "EXTERNAL");
        this.server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NettyAcceptorFactory.class.getCanonicalName(), params, "netty", extraParams));
        String roleName = "widgets";
        Role role = new Role("widgets", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("TEST", roles);
        this.server.start();
    }

    @AfterEach
    public void stopServer() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testConnection() throws Exception {
        String keystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("other-client-keystore.jks").getFile();
        String truststore = ((Object)((Object)this)).getClass().getClassLoader().getResource("server-ca-truststore.jks").getFile();
        String connOptions = "?amqp.saslMechanisms=EXTERNAL&transport.trustStoreLocation=" + truststore + "&transport.trustStorePassword=securepass&transport.keyStoreLocation=" + keystore + "&transport.keyStorePassword=securepass&transport.verifyHost=false";
        JmsConnectionFactory factory = new JmsConnectionFactory(new URI("amqps://localhost:61616" + connOptions));
        connection.start();
        try (jakarta.jms.Connection connection = factory.createConnection("client", null);){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("TEST");
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            MessageProducer producer = session.createProducer((Destination)queue);
            String text = RandomUtil.randomString();
            producer.send((Message)session.createTextMessage(text));
            TextMessage m = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
            Assertions.assertEquals((Object)text, (Object)m.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutbound() throws Exception {
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        config.put("host", "localhost");
        config.put("port", String.valueOf(61616));
        config.put("keyStorePath", "client-keystore.jks");
        config.put("keyStorePassword", "securepass");
        config.put("trustStorePath", "server-ca-truststore.jks");
        config.put("trustStorePassword", "securepass");
        config.put("needClientAuth", true);
        config.put("sslEnabled", true);
        final AtomicBoolean connectionOpened = new AtomicBoolean();
        final AtomicBoolean authFailed = new AtomicBoolean();
        EventHandler eventHandler = new EventHandler(){

            public void onRemoteOpen(Connection connection) throws Exception {
                connectionOpened.set(true);
            }

            public void onAuthFailed(ProtonHandler protonHandler, Connection connection) {
                authFailed.set(true);
            }
        };
        ClientSASLFactory clientSASLFactory = availableMechanims -> {
            final ExternalMechanism externalMechanism = new ExternalMechanism();
            return new ClientSASL(){

                public String getName() {
                    return externalMechanism.getName();
                }

                public byte[] getInitialResponse() {
                    return externalMechanism.getInitialResponse();
                }

                public byte[] getResponse(byte[] challenge) {
                    return new byte[0];
                }
            };
        };
        ProtonClientConnectionManager lifeCycleListener = new ProtonClientConnectionManager(new AMQPClientConnectionFactory(this.server, "myid", Collections.singletonMap(Symbol.getSymbol((String)"myprop"), "propvalue"), 5000), Optional.of(eventHandler), clientSASLFactory);
        ProtonClientProtocolManager protocolManager = new ProtonClientProtocolManager(new ProtonProtocolManagerFactory(), this.server);
        NettyConnector connector = new NettyConnector(config, (BufferHandler)lifeCycleListener, (BaseConnectionLifeCycleListener)lifeCycleListener, (Executor)this.server.getExecutorFactory().getExecutor(), (Executor)this.server.getExecutorFactory().getExecutor(), this.server.getScheduledPool(), (ClientProtocolManager)protocolManager);
        connector.start();
        connector.createConnection();
        try {
            Wait.assertEquals((int)1, () -> ((ActiveMQServer)this.server).getConnectionCount());
            Wait.assertTrue(connectionOpened::get);
            Wait.assertFalse(authFailed::get);
            lifeCycleListener.stop();
            Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
        }
        finally {
            lifeCycleListener.stop();
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = JMSSaslExternalTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

